/*
 * Decompiled with CFR 0.152.
 */
package com.univ.utils.sql.operande;

import com.univ.utils.sql.operande.IntegerOperande;
import com.univ.utils.sql.operande.ListeVarchar;
import com.univ.utils.sql.operande.LongOperande;
import com.univ.utils.sql.operande.NomChamp;
import com.univ.utils.sql.operande.NonEchapable;
import com.univ.utils.sql.operande.Operande;
import com.univ.utils.sql.operande.OperandeDate;
import com.univ.utils.sql.operande.TypeOperande;
import com.univ.utils.sql.operande.VarcharOperande;
import java.sql.Date;
import java.util.Collection;

public class OperandeFactory {
    public static Operande creerOperande(Object valeurOperande, TypeOperande typeValeur) {
        Operande operandeACreer = null;
        if (typeValeur == null) {
            OperandeFactory.gererErreur(valeurOperande, typeValeur);
        }
        switch (typeValeur) {
            case VARCHAR: {
                if (valeurOperande instanceof String) {
                    operandeACreer = new VarcharOperande((String)valeurOperande);
                    break;
                }
                OperandeFactory.gererErreur(valeurOperande, typeValeur);
                break;
            }
            case NOM_CHAMP: {
                if (valeurOperande instanceof String) {
                    operandeACreer = new NomChamp((String)valeurOperande);
                    break;
                }
                OperandeFactory.gererErreur(valeurOperande, typeValeur);
                break;
            }
            case LISTE_VARCHAR: {
                if (valeurOperande instanceof Collection) {
                    operandeACreer = new ListeVarchar((Collection)valeurOperande);
                    break;
                }
                OperandeFactory.gererErreur(valeurOperande, typeValeur);
                break;
            }
            case DATE: {
                if (valeurOperande instanceof Date) {
                    operandeACreer = new OperandeDate((Date)valeurOperande, Boolean.FALSE);
                    break;
                }
                OperandeFactory.gererErreur(valeurOperande, typeValeur);
                break;
            }
            case DATE_ET_HEURE: {
                if (valeurOperande instanceof Date) {
                    operandeACreer = new OperandeDate((Date)valeurOperande, Boolean.TRUE);
                    break;
                }
                OperandeFactory.gererErreur(valeurOperande, typeValeur);
                break;
            }
            case LONG: {
                if (valeurOperande instanceof Long) {
                    operandeACreer = new LongOperande((Long)valeurOperande);
                    break;
                }
                OperandeFactory.gererErreur(valeurOperande, typeValeur);
                break;
            }
            case INTEGER: {
                if (valeurOperande instanceof Integer) {
                    operandeACreer = new IntegerOperande((Integer)valeurOperande);
                    break;
                }
                OperandeFactory.gererErreur(valeurOperande, typeValeur);
                break;
            }
            case NON_ECHAPABLE: {
                if (valeurOperande instanceof String) {
                    operandeACreer = new NonEchapable((String)valeurOperande);
                    break;
                }
                OperandeFactory.gererErreur(valeurOperande, typeValeur);
                break;
            }
            default: {
                if (valeurOperande instanceof String) {
                    operandeACreer = new VarcharOperande((String)valeurOperande);
                    break;
                }
                OperandeFactory.gererErreur(valeurOperande, typeValeur);
            }
        }
        return operandeACreer;
    }

    private static void gererErreur(Object valeurOperande, TypeOperande typeValeur) {
        if (typeValeur == null) {
            throw new IllegalArgumentException("Impossible de creer une Operande de type null");
        }
        if (valeurOperande == null) {
            throw new IllegalArgumentException("Impossible de creer une Operande de type : " + typeValeur.toString() + " avec une valeur null");
        }
        throw new IllegalArgumentException("Impossible de creer une Operande de type : " + typeValeur.toString() + " avec une valeur d'instance : " + valeurOperande.getClass());
    }
}

