/*
 * Decompiled with CFR 0.152.
 */
package com.univ.xhtml;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.filters.AndFilter;
import org.htmlparser.filters.HasAttributeFilter;
import org.htmlparser.filters.NodeClassFilter;
import org.htmlparser.filters.OrFilter;
import org.htmlparser.nodes.TagNode;
import org.htmlparser.tags.ImageTag;
import org.htmlparser.tags.LinkTag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTMLLinkExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(HTMLLinkExtractor.class);
    private static HTMLLinkExtractor _instance;

    private HTMLLinkExtractor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HTMLLinkExtractor GetInstance() {
        if (_instance != null) return _instance;
        Class<HTMLLinkExtractor> clazz = HTMLLinkExtractor.class;
        synchronized (HTMLLinkExtractor.class) {
            if (_instance != null) return _instance;
            _instance = new HTMLLinkExtractor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    private NodeList extractLinksFromUrl(String url, NodeFilter nodeFilter) {
        NodeList list = new NodeList();
        if (url.length() > 0 && nodeFilter != null) {
            try {
                list = new Parser(url).extractAllNodesThatMatch(nodeFilter);
            }
            catch (ParserException e) {
                LOG.error("erreur de parsing de l'url", (Throwable)e);
            }
        }
        return list;
    }

    private NodeList extractLinksFromInput(String input, NodeFilter nodeFilter) {
        NodeList list = new NodeList();
        if (input.length() > 0 && nodeFilter != null) {
            try {
                Parser parser = new Parser();
                parser.setInputHTML(input);
                list = parser.extractAllNodesThatMatch(nodeFilter);
            }
            catch (ParserException e) {
                LOG.error("erreur de parsing de l'input", (Throwable)e);
            }
        }
        return list;
    }

    public List<String> extractAllLinksFromUrl(String url) throws ParserException {
        ArrayList<String> res = new ArrayList<String>();
        HasAttributeFilter srcFilter = new HasAttributeFilter("src");
        HasAttributeFilter hrefFilter = new HasAttributeFilter("href");
        HasAttributeFilter actionFilter = new HasAttributeFilter("action");
        HasAttributeFilter onclickFilter = new HasAttributeFilter("onclick");
        OrFilter nf = new OrFilter((NodeFilter)new OrFilter((NodeFilter)srcFilter, (NodeFilter)hrefFilter), (NodeFilter)new OrFilter((NodeFilter)actionFilter, (NodeFilter)onclickFilter));
        NodeList list = this.extractLinksFromUrl(url, (NodeFilter)nf);
        String link = "";
        for (int i = 0; i < list.size(); ++i) {
            Node node = list.elementAt(i);
            if (node instanceof LinkTag) {
                link = ((LinkTag)node).extractLink();
            } else if (node instanceof ImageTag) {
                link = ((ImageTag)node).extractImageLocn();
            } else if (node instanceof TagNode) {
                if (((TagNode)node).getAttribute("src") != null) {
                    link = ((TagNode)node).getAttribute("src");
                } else if (((TagNode)node).getAttribute("href") != null) {
                    link = ((TagNode)node).getAttribute("href");
                } else if (((TagNode)node).getAttribute("action") != null) {
                    link = ((TagNode)node).getAttribute("action");
                } else if (((TagNode)node).getAttribute("onclick") != null) {
                    link = ((TagNode)node).getAttribute("onclick");
                }
            }
            if (link.startsWith("#")) continue;
            res.add(link);
        }
        return res;
    }

    public List<String> extractAllLinksFromInput(String input) throws ParserException {
        ArrayList<String> res = new ArrayList<String>();
        HasAttributeFilter srcFilter = new HasAttributeFilter("src");
        HasAttributeFilter hrefFilter = new HasAttributeFilter("href");
        HasAttributeFilter actionFilter = new HasAttributeFilter("action");
        HasAttributeFilter onclickFilter = new HasAttributeFilter("onclick");
        OrFilter nf = new OrFilter((NodeFilter)new OrFilter((NodeFilter)srcFilter, (NodeFilter)hrefFilter), (NodeFilter)new OrFilter((NodeFilter)actionFilter, (NodeFilter)onclickFilter));
        NodeList list = this.extractLinksFromInput(input, (NodeFilter)nf);
        String link = "";
        for (int i = 0; i < list.size(); ++i) {
            Node node = list.elementAt(i);
            if (node instanceof LinkTag) {
                link = ((LinkTag)node).extractLink();
            } else if (node instanceof ImageTag) {
                link = ((ImageTag)node).extractImageLocn();
            } else if (node instanceof TagNode) {
                if (((TagNode)node).getAttribute("src") != null) {
                    link = ((TagNode)node).getAttribute("src");
                } else if (((TagNode)node).getAttribute("href") != null) {
                    link = ((TagNode)node).getAttribute("href");
                } else if (((TagNode)node).getAttribute("action") != null) {
                    link = ((TagNode)node).getAttribute("action");
                } else if (((TagNode)node).getAttribute("onclick") != null) {
                    link = ((TagNode)node).getAttribute("onclick");
                }
            }
            if (link.startsWith("#")) continue;
            res.add(link);
        }
        return res;
    }

    public List<String> extractLinksHtmlFromUrl(String url) {
        ArrayList<String> res = new ArrayList<String>();
        AndFilter nf = new AndFilter((NodeFilter)new NodeClassFilter(LinkTag.class), new NodeFilter(){
            private static final long serialVersionUID = -8219547060385109384L;

            public boolean accept(Node node) {
                boolean res = false;
                if (!((LinkTag)node).isMailLink() && !((LinkTag)node).isJavascriptLink()) {
                    res = true;
                }
                return res;
            }
        });
        NodeList list = this.extractLinksFromUrl(url, (NodeFilter)nf);
        for (int i = 0; i < list.size(); ++i) {
            res.add(((LinkTag)list.elementAt(i)).getLink());
        }
        return res;
    }

    public List<String> extractLinksHtmlFromInput(String urlBase, String input) {
        return this.extractLinksHtmlFromInput(urlBase, input, false);
    }

    public List<String> extractLinksHtmlFromInput(String urlBase, String input, boolean excludeAnchor) {
        ArrayList<String> res = new ArrayList<String>();
        AndFilter nf = new AndFilter((NodeFilter)new NodeClassFilter(LinkTag.class), new NodeFilter(){
            private static final long serialVersionUID = 2915510831612396731L;

            public boolean accept(Node node) {
                boolean res = false;
                if (((LinkTag)node).isHTTPLikeLink() || ((LinkTag)node).isHTTPLink() || ((LinkTag)node).isHTTPSLink()) {
                    res = true;
                }
                return res;
            }
        });
        NodeList list = this.extractLinksFromInput(input, (NodeFilter)nf);
        String link = "";
        int nIndexDiese = -1;
        for (int i = 0; i < list.size(); ++i) {
            link = ((LinkTag)list.elementAt(i)).getLink();
            nIndexDiese = link.indexOf(35);
            if (nIndexDiese != -1) {
                link = link.substring(0, nIndexDiese);
                if (excludeAnchor && StringUtils.isBlank((CharSequence)link)) continue;
            }
            if (!link.toLowerCase().startsWith("http") && urlBase != null) {
                if (link.toLowerCase().startsWith("www")) {
                    link = "http://" + link;
                } else {
                    try {
                        link = new URL(new URL(urlBase), link).toString();
                    }
                    catch (MalformedURLException e) {
                        LOG.debug(e.getMessage());
                    }
                }
            }
            res.add(link);
        }
        return res;
    }
}

