/*
 * Decompiled with CFR 0.152.
 */
package com.univ.xhtml;

import org.apache.commons.lang3.StringUtils;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.beans.StringBean;
import org.htmlparser.filters.TagNameFilter;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.htmlparser.visitors.NodeVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTMLStringExtractor {
    private static Logger LOG = LoggerFactory.getLogger(HTMLStringExtractor.class);
    private static HTMLStringExtractor _instance;

    private HTMLStringExtractor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HTMLStringExtractor GetInstance() {
        if (_instance != null) return _instance;
        Class<HTMLStringExtractor> clazz = HTMLStringExtractor.class;
        synchronized (HTMLStringExtractor.class) {
            if (_instance != null) return _instance;
            _instance = new HTMLStringExtractor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    public String extractAllStrings(String url, boolean links) {
        String res = "";
        try {
            StringBean sb = new StringBean();
            sb.setLinks(links);
            sb.setURL(url);
            res = sb.getStrings();
        }
        catch (Exception e) {
            LOG.debug("Probl\u00e8me d'extraction du contenu", (Throwable)e);
        }
        return res;
    }

    public NodeList extractTagFromInput(String input, TagNameFilter tagNameFilter) {
        NodeList res = new NodeList();
        try {
            Parser parser = new Parser();
            parser.setInputHTML(input);
            res = parser.extractAllNodesThatMatch((NodeFilter)tagNameFilter);
        }
        catch (Exception e) {
            LOG.debug("Probl\u00e8me d'extraction du contenu", (Throwable)e);
        }
        return res;
    }

    public String extractAllStringsFromInput(String input, boolean links) {
        String res = "";
        if (input.length() > 0) {
            try {
                StringBean sb = new StringBean();
                sb.setLinks(links);
                Parser parser = new Parser();
                parser.setInputHTML(input);
                parser.visitAllNodesWith((NodeVisitor)sb);
                res = sb.getStrings();
            }
            catch (ParserException e) {
                LOG.debug("Probl\u00e8me d'extraction du contenu", (Throwable)e);
            }
        }
        return StringUtils.defaultString((String)res);
    }
}

