/*
 * Decompiled with CFR 0.152.
 */
package com.univ.xhtml;

import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.InfosGroupeDsi;
import com.univ.xhtml.JavascriptTree;
import com.univ.xhtml.JavascriptTreeItem;
import java.util.Iterator;

public class JavascriptTreeGroupedsi {
    private JavascriptTree tree = new JavascriptTree();
    private AutorisationBean autorisations = null;
    private String permissions = null;

    public JavascriptTreeGroupedsi(AutorisationBean autorisations, String permissions) {
        this.autorisations = autorisations;
        this.permissions = permissions;
    }

    public void load(InfosGroupeDsi groupe, InfosGroupeDsi groupeSelectionne) throws Exception {
        Iterator<InfosGroupeDsi> listSousGroupesIt = groupe.getListeSousGroupesSortedByLibelle().iterator();
        InfosGroupeDsi sousGroupe = null;
        boolean selectable = true;
        while (listSousGroupesIt.hasNext()) {
            sousGroupe = listSousGroupesIt.next();
            if (!this.isGroupeVisible(sousGroupe, selectable = this.isGroupeSelectable(sousGroupe))) continue;
            this.tree.addItem(new JavascriptTreeItem(sousGroupe.getCodeGroupePere(), sousGroupe.getCode(), sousGroupe.getIntitule(), sousGroupe.contains(groupeSelectionne), selectable));
            if (sousGroupe.getListeSousGroupes().isEmpty()) continue;
            this.load(sousGroupe, groupeSelectionne);
        }
    }

    public String print() {
        return this.tree.print();
    }

    private boolean isGroupeSelectable(InfosGroupeDsi groupeDsi) throws Exception {
        boolean selectableItem = groupeDsi.isSelectionnable();
        if (selectableItem && this.permissions.length() > 0) {
            selectableItem = this.permissions.startsWith("DYN") ? groupeDsi.getRequete().length() <= 0 : Groupedsi.controlerPermission(this.autorisations, this.permissions, groupeDsi.getCode());
        }
        return selectableItem;
    }

    private boolean isGroupeVisible(InfosGroupeDsi groupe, boolean selectable) throws Exception {
        boolean visible = selectable;
        if (!selectable) {
            Iterator<InfosGroupeDsi> listSousGroupesIt = groupe.getListeSousGroupes().iterator();
            InfosGroupeDsi sousGroupe = null;
            while (listSousGroupesIt.hasNext() && !visible) {
                sousGroupe = listSousGroupesIt.next();
                visible = this.isGroupeVisible(sousGroupe, this.isGroupeSelectable(sousGroupe));
            }
        }
        return visible;
    }
}

