/*
 * Decompiled with CFR 0.152.
 */
package com.univ.xhtml;

import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.Rubrique;
import com.univ.xhtml.JavascriptTree;
import com.univ.xhtml.JavascriptTreeItem;
import java.util.Iterator;

public class JavascriptTreeRubrique {
    private JavascriptTree tree = new JavascriptTree();
    private AutorisationBean autorisations = null;
    private String permissions = null;

    public JavascriptTreeRubrique(AutorisationBean autorisations, String permissions) {
        this.autorisations = autorisations;
        this.permissions = permissions;
    }

    public void load(InfosRubriques rubrique, InfosRubriques rubriqueSelectionnee) throws Exception {
        Iterator<InfosRubriques> listSousRubriquesIt = rubrique.getListeSousRubriques().iterator();
        InfosRubriques sousRubrique = null;
        boolean selectable = true;
        while (listSousRubriquesIt.hasNext()) {
            sousRubrique = listSousRubriquesIt.next();
            if (!this.isRubriqueVisible(sousRubrique, selectable = this.isRubriqueSelectable(sousRubrique))) continue;
            this.tree.addItem(new JavascriptTreeItem(sousRubrique.getCodeRubriqueMere(), sousRubrique.getCode(), sousRubrique.getIntitule(), sousRubrique.contains(rubriqueSelectionnee), selectable));
            if (sousRubrique.getListeSousRubriques().isEmpty()) continue;
            this.load(sousRubrique, rubriqueSelectionnee);
        }
    }

    public String print() {
        return this.tree.print();
    }

    private boolean isRubriqueSelectable(InfosRubriques rubrique) throws Exception {
        boolean selectableItem = true;
        if (this.permissions.length() > 0) {
            selectableItem = Rubrique.controlerPermission(this.autorisations, this.permissions, rubrique.getCode());
        }
        return selectableItem;
    }

    private boolean isRubriqueVisible(InfosRubriques rubrique, boolean selectable) throws Exception {
        boolean visible = selectable;
        if (!selectable) {
            Iterator<InfosRubriques> listSousRubriquesIt = rubrique.getListeSousRubriques().iterator();
            InfosRubriques sousRubrique = null;
            while (listSousRubriquesIt.hasNext() && !visible) {
                sousRubrique = listSousRubriquesIt.next();
                visible = this.isRubriqueVisible(sousRubrique, this.isRubriqueSelectable(sousRubrique));
            }
        }
        return visible;
    }
}

