/*
 * Decompiled with CFR 0.152.
 */
package com.univ.xhtml;

import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.InfosStructure;
import com.univ.objetspartages.om.PermissionBean;
import com.univ.objetspartages.om.Structure;
import com.univ.xhtml.JavascriptTree;
import com.univ.xhtml.JavascriptTreeItem;
import com.univ.xhtml.TypeStructureFilter;
import java.util.Iterator;

public class JavascriptTreeStructure {
    private JavascriptTree tree = new JavascriptTree();
    private AutorisationBean autorisations = null;
    private String permissions = null;
    private TypeStructureFilter filter = null;
    private boolean front = false;

    public JavascriptTreeStructure(AutorisationBean autorisations, String permissions, String typeStructureList, boolean front) {
        if (typeStructureList.length() > 0) {
            this.filter = new TypeStructureFilter(typeStructureList);
        }
        this.autorisations = autorisations;
        this.permissions = permissions;
        this.front = front;
    }

    public void load(InfosStructure structure, InfosStructure structureSelectionnee) {
        Iterator<InfosStructure> listSousStructuresIt = structure.getListeSousStructuresSortedByLibelleLong().iterator();
        InfosStructure sousStructure = null;
        boolean selectable = true;
        while (listSousStructuresIt.hasNext()) {
            sousStructure = listSousStructuresIt.next();
            if (this.front && !sousStructure.isVisibleInFront() || !this.isStructureVisible(sousStructure, selectable = this.isStructureSelectable(sousStructure))) continue;
            this.tree.addItem(new JavascriptTreeItem(sousStructure.getCodeRattachement(), sousStructure.getCode(), sousStructure.getLibelleLong(), sousStructure.contains(structureSelectionnee), selectable));
            if (sousStructure.getListeSousStructures().isEmpty()) continue;
            this.load(sousStructure, structureSelectionnee);
        }
    }

    public String print() {
        return this.tree.print();
    }

    private boolean isStructureSelectable(InfosStructure structure) {
        boolean selectableItem = true;
        if (this.permissions.length() > 0) {
            selectableItem = Structure.controlerPermission(this.autorisations, this.permissions, structure.getCode());
        }
        if (this.filter != null && selectableItem) {
            selectableItem = this.filter.accept(structure.getTypeStructure());
        }
        PermissionBean permissionCourante = new PermissionBean(this.permissions);
        if (!selectableItem && this.autorisations != null && this.autorisations.isRedacteurFicheCourante() && (permissionCourante.getObjet().equals("0006") || permissionCourante.getObjet().equals("0007") || permissionCourante.getObjet().equals("0013")) && !this.autorisations.possedePermission(permissionCourante)) {
            selectableItem = true;
        }
        return selectableItem;
    }

    private boolean isStructureVisible(InfosStructure structure, boolean selectable) {
        boolean visible = selectable;
        if (!selectable) {
            Iterator<InfosStructure> listSousStructuresIt = structure.getListeSousStructures().iterator();
            InfosStructure sousStructure = null;
            while (listSousStructuresIt.hasNext() && !visible) {
                sousStructure = listSousStructuresIt.next();
                if (this.front && !sousStructure.isVisibleInFront()) continue;
                visible = this.isStructureVisible(sousStructure, this.isStructureSelectable(sousStructure));
            }
        }
        return visible;
    }
}

