/*
 * Decompiled with CFR 0.152.
 */
package com.univ.xhtml.pdf;

import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.univ.xhtml.pdf.IGenerateurPDF;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefautGenerateurPDF
implements IGenerateurPDF {
    private static final String INDENT_YES = "yes";
    private static final Logger LOG = LoggerFactory.getLogger(DefautGenerateurPDF.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createPDF(InputStream is, OutputStream os) throws ErreurApplicative {
        FopFactory fopFactory = FopFactory.newInstance();
        FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
        try {
            Fop fop = fopFactory.newFop("application/pdf", foUserAgent, os);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setParameter("versionParam", "2.0");
            transformer.setOutputProperty("encoding", "UTF-8".toLowerCase());
            transformer.setOutputProperty("indent", INDENT_YES);
            StreamSource src = new StreamSource(is);
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            transformer.transform(src, res);
        }
        catch (FOPException e) {
            String messErr = "Erreur dans la g\u00e9n\u00e9ration du PDF via FOP";
            LOG.error(messErr, (Throwable)e);
            throw new ErreurApplicative(messErr);
        }
        catch (TransformerConfigurationException e) {
            String messErr = "Erreur dans la g\u00e9n\u00e9ration du PDF via FOP : impossible d'initialiser le transformer";
            LOG.error(messErr, (Throwable)e);
        }
        catch (TransformerException e) {
            String messErr = "Erreur dans la g\u00e9n\u00e9ration du PDF via FOP : impossible de convertir le flux en pdf";
            LOG.error(messErr, (Throwable)e);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {
                LOG.error("Echec fermeture du flux PDF", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createPDF(File fXml, File fXslt, OutputStream os) throws ErreurApplicative {
        FopFactory fopFactory = FopFactory.newInstance();
        FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
        try {
            Fop fop = fopFactory.newFop("application/pdf", foUserAgent, os);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(new StreamSource(fXslt));
            transformer.setParameter("versionParam", "2.0");
            transformer.setOutputProperty("encoding", "UTF-8".toLowerCase());
            transformer.setOutputProperty("indent", INDENT_YES);
            StreamSource src = new StreamSource(fXml);
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            transformer.transform(src, res);
        }
        catch (FOPException e) {
            String messErr = "Erreur dans la g\u00e9n\u00e9ration du PDF via FOP";
            LOG.error(messErr, (Throwable)e);
            throw new ErreurApplicative(messErr);
        }
        catch (TransformerConfigurationException e) {
            String messErr = "Erreur dans la g\u00e9n\u00e9ration du PDF via FOP : impossible d'initialiser le transformer";
            LOG.error(messErr, (Throwable)e);
        }
        catch (TransformerException e) {
            String messErr = "Erreur dans la g\u00e9n\u00e9ration du PDF via FOP : impossible de convertir le flux en pdf";
            LOG.error(messErr, (Throwable)e);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {
                LOG.error("Echec fermeture du flux PDF", (Throwable)e);
            }
        }
    }
}

