/*
 * Decompiled with CFR 0.152.
 */
package com.univ.xhtml.pdf;

import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.core.config.PropertyHelper;
import com.univ.xhtml.pdf.DefautGenerateurPDF;
import com.univ.xhtml.pdf.IGenerateurPDF;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFManipulateur {
    public static final String PARAM_JTF_PDF_GENERATION_CLASS = "pdf.generation_impl";
    private static PDFManipulateur _instance;
    private static final Logger LOG;
    private IGenerateurPDF pdfGenerationImpl;

    public static void createPDF(InputStream is, OutputStream os) throws ErreurApplicative {
        PDFManipulateur.createInstance();
        PDFManipulateur._instance.pdfGenerationImpl.createPDF(is, os);
    }

    public static void createPDF(File xmlFile, File xsltFile, OutputStream os) throws ErreurApplicative {
        PDFManipulateur.createInstance();
        PDFManipulateur._instance.pdfGenerationImpl.createPDF(xmlFile, xsltFile, os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void createInstance() {
        if (_instance != null) return;
        Class<PDFManipulateur> clazz = PDFManipulateur.class;
        synchronized (PDFManipulateur.class) {
            if (_instance != null) return;
            _instance = new PDFManipulateur();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private void loadImpl() {
        String nomClasse = PropertyHelper.getCoreProperty(PARAM_JTF_PDF_GENERATION_CLASS);
        if (nomClasse != null) {
            Object o = null;
            try {
                o = Class.forName(nomClasse).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOG.error("Echec chargement generateur PDF", (Throwable)e);
            }
            if (o != null && o instanceof IGenerateurPDF) {
                this.pdfGenerationImpl = o;
                LOG.debug("Generateur PDF " + this.pdfGenerationImpl);
            } else {
                this.pdfGenerationImpl = new DefautGenerateurPDF();
            }
        } else {
            this.pdfGenerationImpl = new DefautGenerateurPDF();
        }
    }

    private PDFManipulateur() {
        this.loadImpl();
    }

    static {
        LOG = LoggerFactory.getLogger(PDFManipulateur.class);
    }
}

