/*
 * Decompiled with CFR 0.152.
 */
package fr.kosmos.web.projets.extensions.social.card.view.builder.impl;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kosmos.layout.card.view.model.CardViewModel;
import com.kportal.core.config.PropertyHelper;
import fr.kosmos.web.projets.extensions.social.bean.FacebookFeedBean;
import fr.kosmos.web.projets.extensions.social.card.bean.FacebookCardBean;
import fr.kosmos.web.projets.extensions.social.card.view.model.FacebookCardViewModel;
import fr.kosmos.web.projets.extensions.social.exception.SocialException;
import fr.kosmos.web.projets.extensions.social.service.ServiceFacebook;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacebookCardViewModelBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(FacebookCardViewModelBuilder.class);
    public static final String PROPRIETE_FACEBOOK_CARD_MAXPOSTS = "social.facebook.card.maxposts";
    public static final int PROPRIETE_FACEBOOK_CARD_MAXPOSTS_DEFAUT = 3;

    private FacebookCardViewModelBuilder() {
    }

    public static FacebookCardViewModel buildViewModel(CardViewModel cardView) {
        if (cardView != null && cardView.getCardBean() != null) {
            FacebookCardViewModel facebookCardView = new FacebookCardViewModel();
            FacebookCardBean cardBean = (FacebookCardBean)cardView.getCardBean();
            facebookCardView.setCardBean(cardView.getCardBean());
            facebookCardView.setJsonCard(cardView.getJsonCard());
            facebookCardView.setTitle(cardBean.getTitle());
            facebookCardView.setContent(FacebookCardViewModelBuilder.getFeed(cardBean));
            return facebookCardView;
        }
        LOG.error("Exception rencontr\u00e9e \u00e0 la lecture de la carte Facebook");
        return null;
    }

    protected static List<FacebookFeedBean> getFeed(FacebookCardBean cardBean) {
        ServiceFacebook serviceFacebook = (ServiceFacebook)ApplicationContextManager.getBean((String)"social", (String)"serviceFacebook", ServiceFacebook.class);
        int maxItem = PropertyHelper.getPropertyAsInt((String)"social", (String)PROPRIETE_FACEBOOK_CARD_MAXPOSTS, (int)3);
        try {
            List<FacebookFeedBean> listePosts = serviceFacebook.getPosts(cardBean.getIduser(), maxItem);
            return listePosts;
        }
        catch (SocialException e) {
            LOG.warn("Erreur lors de la r\u00e9cup\u00e9ration des posts de la carte {}", (Object)cardBean, (Object)e);
            throw e;
        }
    }
}

