/*
 * Decompiled with CFR 0.152.
 */
package fr.kosmos.web.projets.extensions.social.card.view.builder.impl;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kosmos.layout.card.view.model.CardViewModel;
import com.kportal.core.config.PropertyHelper;
import fr.kosmos.web.projets.extensions.social.bean.InstagramFeedBean;
import fr.kosmos.web.projets.extensions.social.card.bean.InstagramCardBean;
import fr.kosmos.web.projets.extensions.social.card.view.model.InstagramCardViewModel;
import fr.kosmos.web.projets.extensions.social.exception.SocialException;
import fr.kosmos.web.projets.extensions.social.service.ServiceInstagram;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstagramCardViewModelBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(InstagramCardViewModelBuilder.class);
    public static final String PROPRIETE_INSTAGRAM_CARD_MAXPOSTS = "social.instagram.card.maxposts";
    public static final int PROPRIETE_INSTAGRAM_CARD_MAXPOSTS_DEFAUT = 3;

    private InstagramCardViewModelBuilder() {
    }

    public static InstagramCardViewModel buildViewModel(CardViewModel cardView) {
        if (cardView != null && cardView.getCardBean() != null) {
            InstagramCardViewModel instagramCardView = new InstagramCardViewModel();
            InstagramCardBean cardBean = (InstagramCardBean)cardView.getCardBean();
            instagramCardView.setCardBean(cardView.getCardBean());
            instagramCardView.setJsonCard(cardView.getJsonCard());
            instagramCardView.setTitle(cardBean.getTitle());
            instagramCardView.setContent(InstagramCardViewModelBuilder.getFeed(cardBean));
            return instagramCardView;
        }
        LOG.error("Exception rencontr\u00e9e \u00e0 la lecture de la carte Instagram");
        return null;
    }

    protected static List<InstagramFeedBean> getFeed(InstagramCardBean cardBean) {
        ServiceInstagram serviceInstagram = (ServiceInstagram)ApplicationContextManager.getBean((String)"social", (String)"serviceInstagram", ServiceInstagram.class);
        int maxVideos = PropertyHelper.getPropertyAsInt((String)"social", (String)PROPRIETE_INSTAGRAM_CARD_MAXPOSTS, (int)3);
        try {
            return serviceInstagram.getFeed(cardBean.getIduser(), maxVideos);
        }
        catch (SocialException e) {
            LOG.warn("Erreur lors de la r\u00e9cup\u00e9ration des tweets de la carte {}", (Object)cardBean, (Object)e);
            throw e;
        }
    }
}

