/*
 * Decompiled with CFR 0.152.
 */
package fr.kosmos.web.projets.extensions.social.card.view.builder.impl;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kosmos.layout.card.view.model.CardViewModel;
import com.kportal.core.config.PropertyHelper;
import fr.kosmos.web.projets.extensions.social.bean.LinkedinFeedBean;
import fr.kosmos.web.projets.extensions.social.card.bean.LinkedinCardBean;
import fr.kosmos.web.projets.extensions.social.card.view.model.LinkedinCardViewModel;
import fr.kosmos.web.projets.extensions.social.exception.SocialException;
import fr.kosmos.web.projets.extensions.social.service.ServiceLinkedin;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkedinCardViewModelBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(LinkedinCardViewModelBuilder.class);
    public static final String PROPRIETE_LINKEDIN_CARD_MAXPOSTS = "social.linkedin.card.maxposts";
    public static final int PROPRIETE_LINKEDIN_CARD_MAXPOSTS_DEFAUT = 3;

    private LinkedinCardViewModelBuilder() {
    }

    public static LinkedinCardViewModel buildViewModel(CardViewModel cardView) {
        if (cardView != null && cardView.getCardBean() != null) {
            LinkedinCardViewModel linkedinCardView = new LinkedinCardViewModel();
            LinkedinCardBean cardBean = (LinkedinCardBean)cardView.getCardBean();
            linkedinCardView.setCardBean(cardView.getCardBean());
            linkedinCardView.setJsonCard(cardView.getJsonCard());
            linkedinCardView.setTitle(cardBean.getTitle());
            linkedinCardView.setContent(LinkedinCardViewModelBuilder.getPosts(cardBean));
            return linkedinCardView;
        }
        LOG.error("Exception rencontr\u00e9e \u00e0 la lecture de la carte Linkedin");
        return null;
    }

    protected static List<LinkedinFeedBean> getPosts(LinkedinCardBean cardBean) {
        ServiceLinkedin serviceLinkedin = (ServiceLinkedin)ApplicationContextManager.getBean((String)"social", (String)"serviceLinkedin", ServiceLinkedin.class);
        int maxPosts = PropertyHelper.getPropertyAsInt((String)"social", (String)PROPRIETE_LINKEDIN_CARD_MAXPOSTS, (int)3);
        try {
            return serviceLinkedin.getPosts(cardBean.getIduser(), maxPosts);
        }
        catch (SocialException e) {
            LOG.warn("Erreur lors de la r\u00e9cup\u00e9ration des tweets de la carte {}", (Object)cardBean, (Object)e);
            throw e;
        }
    }
}

