/*
 * Decompiled with CFR 0.152.
 */
package fr.kosmos.web.projets.extensions.social.card.view.builder.impl;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kosmos.layout.card.view.model.CardViewModel;
import com.kportal.core.config.PropertyHelper;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import fr.kosmos.web.projets.extensions.social.bean.FacebookFeedBean;
import fr.kosmos.web.projets.extensions.social.bean.InstagramFeedBean;
import fr.kosmos.web.projets.extensions.social.bean.LinkedinFeedBean;
import fr.kosmos.web.projets.extensions.social.bean.SocialBean;
import fr.kosmos.web.projets.extensions.social.bean.TweetBean;
import fr.kosmos.web.projets.extensions.social.bean.YoutubeVideoBean;
import fr.kosmos.web.projets.extensions.social.card.bean.ReseauxSociauxCardBean;
import fr.kosmos.web.projets.extensions.social.card.bean.TwitterCardApi;
import fr.kosmos.web.projets.extensions.social.card.bean.YoutubeCardApi;
import fr.kosmos.web.projets.extensions.social.card.view.model.ReseauxSociauxCardViewModel;
import fr.kosmos.web.projets.extensions.social.exception.SocialException;
import fr.kosmos.web.projets.extensions.social.service.ServiceFacebook;
import fr.kosmos.web.projets.extensions.social.service.ServiceInstagram;
import fr.kosmos.web.projets.extensions.social.service.ServiceLinkedin;
import fr.kosmos.web.projets.extensions.social.service.ServiceTwitter;
import fr.kosmos.web.projets.extensions.social.service.ServiceYoutube;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ComparatorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReseauxSociauxCardViewModelBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ReseauxSociauxCardViewModelBuilder.class);
    public static final String PROPRIETE_RESEAUXSOCIAUX_CARD_MAX = "social.reseauxsociaux.card.max";
    public static final int PROPRIETE_RESEAUXSOCIAUX_CARD_MAX_DEFAUT = 3;
    public static final int PROPRIETE_RESEAUXSOCIAUX_CARD_MAX_MAXIMUM = 20;
    public static final Comparator<SocialBean> COMPARATOR_SOCIAL_BEAN_DATE_DESC = new Comparator<SocialBean>(){

        @Override
        public int compare(SocialBean o1, SocialBean o2) {
            return ComparatorUtils.NATURAL_COMPARATOR.compare(o2.getDateCreated(), o1.getDateCreated());
        }
    };

    private ReseauxSociauxCardViewModelBuilder() {
    }

    public static ReseauxSociauxCardViewModel buildViewModel(CardViewModel cardView) throws InterruptedException {
        if (cardView != null && cardView.getCardBean() != null) {
            ReseauxSociauxCardViewModel reseauxSociauxCardView = new ReseauxSociauxCardViewModel();
            ReseauxSociauxCardBean cardBean = (ReseauxSociauxCardBean)cardView.getCardBean();
            reseauxSociauxCardView.setCardBean(cardView.getCardBean());
            reseauxSociauxCardView.setJsonCard(cardView.getJsonCard());
            reseauxSociauxCardView.setTitle(cardBean.getTitle());
            List<SocialBean> socialBeanList = ReseauxSociauxCardViewModelBuilder.getContent(cardBean);
            reseauxSociauxCardView.setContent(socialBeanList);
            reseauxSociauxCardView.setCount(socialBeanList.size());
            int countFacebook = 0;
            int countInstagram = 0;
            int countLinkedin = 0;
            int countTwitter = 0;
            int countYoutube = 0;
            for (SocialBean socialBean : socialBeanList) {
                String type = socialBean.getType();
                if ("facebook".equals(type)) {
                    ++countFacebook;
                    continue;
                }
                if ("instagram".equals(type)) {
                    ++countInstagram;
                    continue;
                }
                if ("linkedin".equals(type)) {
                    ++countLinkedin;
                    continue;
                }
                if ("twitter".equals(type)) {
                    ++countTwitter;
                    continue;
                }
                if (!"youtube".equals(type)) continue;
                ++countYoutube;
            }
            reseauxSociauxCardView.setCountFacebook(countFacebook);
            reseauxSociauxCardView.setCountInstagram(countInstagram);
            reseauxSociauxCardView.setCountLinkedin(countLinkedin);
            reseauxSociauxCardView.setCountTwitter(countTwitter);
            reseauxSociauxCardView.setCountYoutube(countYoutube);
            return reseauxSociauxCardView;
        }
        LOG.error("Exception rencontr\u00e9e \u00e0 la lecture de la carte Youtube");
        return null;
    }

    protected static List<SocialBean> getContent(final ReseauxSociauxCardBean cardBean) throws InterruptedException {
        ArrayList<SocialBean> content = new ArrayList<SocialBean>();
        ArrayList<Callable<List<SocialBean>>> taches = new ArrayList<Callable<List<SocialBean>>>();
        final ContexteUniv contexteThreadPrincipal = ContexteUtil.getContexteUniv();
        Callable<List<? extends SocialBean>> youtubeContent = new Callable<List<? extends SocialBean>>(){

            @Override
            public List<? extends SocialBean> call() throws Exception {
                ReseauxSociauxCardViewModelBuilder.recopierInfosContexteUniv(contexteThreadPrincipal);
                try {
                    List<YoutubeVideoBean> list = ReseauxSociauxCardViewModelBuilder.getContentYoutube(cardBean);
                    return list;
                }
                finally {
                    ContexteUtil.releaseContexteUniv();
                }
            }
        };
        taches.add(youtubeContent);
        Callable<List<? extends SocialBean>> facebookContent = new Callable<List<? extends SocialBean>>(){

            @Override
            public List<? extends SocialBean> call() throws Exception {
                ReseauxSociauxCardViewModelBuilder.recopierInfosContexteUniv(contexteThreadPrincipal);
                try {
                    List<FacebookFeedBean> list = ReseauxSociauxCardViewModelBuilder.getContentFacebook(cardBean);
                    return list;
                }
                finally {
                    ContexteUtil.releaseContexteUniv();
                }
            }
        };
        taches.add(facebookContent);
        Callable<List<? extends SocialBean>> twitterContent = new Callable<List<? extends SocialBean>>(){

            @Override
            public List<? extends SocialBean> call() throws Exception {
                ReseauxSociauxCardViewModelBuilder.recopierInfosContexteUniv(contexteThreadPrincipal);
                try {
                    List<TweetBean> list = ReseauxSociauxCardViewModelBuilder.getContentTwitter(cardBean);
                    return list;
                }
                finally {
                    ContexteUtil.releaseContexteUniv();
                }
            }
        };
        taches.add(twitterContent);
        Callable<List<? extends SocialBean>> instagramContent = new Callable<List<? extends SocialBean>>(){

            @Override
            public List<? extends SocialBean> call() throws Exception {
                ReseauxSociauxCardViewModelBuilder.recopierInfosContexteUniv(contexteThreadPrincipal);
                try {
                    List<InstagramFeedBean> list = ReseauxSociauxCardViewModelBuilder.getContentInstagram(cardBean);
                    return list;
                }
                finally {
                    ContexteUtil.releaseContexteUniv();
                }
            }
        };
        taches.add(instagramContent);
        Callable<List<? extends SocialBean>> linkedinContent = new Callable<List<? extends SocialBean>>(){

            @Override
            public List<? extends SocialBean> call() throws Exception {
                ReseauxSociauxCardViewModelBuilder.recopierInfosContexteUniv(contexteThreadPrincipal);
                try {
                    List<LinkedinFeedBean> list = ReseauxSociauxCardViewModelBuilder.getContentLinkedin(cardBean);
                    return list;
                }
                finally {
                    ContexteUtil.releaseContexteUniv();
                }
            }
        };
        taches.add(linkedinContent);
        ExecutorService executorService = Executors.newFixedThreadPool(taches.size());
        try {
            List tachesTerminees = executorService.invokeAll(taches);
            for (Future tacheTerminee : tachesTerminees) {
                if (!tacheTerminee.isDone()) continue;
                try {
                    List result = (List)tacheTerminee.get();
                    if (!CollectionUtils.isNotEmpty((Collection)result)) continue;
                    for (SocialBean socialBean : result) {
                        content.add(socialBean);
                    }
                }
                catch (ExecutionException e) {
                    LOG.error("Erreur dans l'exectution des threads des r\u00e9seaux sociaux", (Throwable)e);
                }
            }
        }
        catch (InterruptedException e) {
            LOG.error("Erreur dans la gestion du pool de threads pour l'ex\u00e9cution des r\u00e9seaux sociaux", (Throwable)e);
            throw e;
        }
        finally {
            LOG.debug("Arr\u00eat de l'ex\u00e9cuteur de t\u00e2ches de la tuile multi-r\u00e9seaux sociaux");
            executorService.shutdown();
        }
        Collections.sort(content, COMPARATOR_SOCIAL_BEAN_DATE_DESC);
        return content;
    }

    protected static void recopierInfosContexteUniv(ContexteUniv contexteParent) {
        ContexteUniv contexteActuel = ContexteUtil.getContexteUniv();
        if (contexteActuel == null) {
            contexteActuel = ContexteUtil.setContexteSansRequete();
        }
        contexteActuel.setInfosSite(contexteParent.getInfosSite());
    }

    protected static List<YoutubeVideoBean> getContentYoutube(ReseauxSociauxCardBean cardBean) {
        List<YoutubeVideoBean> content = new ArrayList<YoutubeVideoBean>();
        if (cardBean.isYoutubeEnabled()) {
            ServiceYoutube serviceYoutube = (ServiceYoutube)ApplicationContextManager.getBean((String)"social", (String)"serviceYoutube", ServiceYoutube.class);
            String type = cardBean.getYoutubeType();
            int maxVideos = ReseauxSociauxCardViewModelBuilder.maxProperty(cardBean.getYoutubeMax());
            try {
                content = YoutubeCardApi.PLAYLISTITEMS.name().equals(type) ? serviceYoutube.getPlaylistVideos(cardBean.getYoutubePlaylist(), maxVideos) : serviceYoutube.getChannelVideos(cardBean.getYoutubeQuery(), cardBean.getYoutubeChannel(), maxVideos);
            }
            catch (SocialException se) {
                LOG.error("Erreur lors du calcul du flux Youtube pour la carte {}.", (Object)cardBean, (Object)se);
            }
        }
        return content;
    }

    protected static List<InstagramFeedBean> getContentInstagram(ReseauxSociauxCardBean cardBean) {
        ArrayList<InstagramFeedBean> content = new ArrayList<InstagramFeedBean>();
        if (cardBean.isInstagramEnabled()) {
            ServiceInstagram serviceInstagram = (ServiceInstagram)ApplicationContextManager.getBean((String)"social", (String)"serviceInstagram", ServiceInstagram.class);
            try {
                content.addAll(serviceInstagram.getFeed(cardBean.getInstagramIduser(), ReseauxSociauxCardViewModelBuilder.maxProperty(cardBean.getInstagramMax())));
            }
            catch (SocialException se) {
                LOG.error("Erreur lors du calcul du flux Instagram pour la carte {}.", (Object)cardBean, (Object)se);
            }
        }
        return content;
    }

    protected static List<LinkedinFeedBean> getContentLinkedin(ReseauxSociauxCardBean cardBean) {
        ArrayList<LinkedinFeedBean> content = new ArrayList<LinkedinFeedBean>();
        if (cardBean.isLinkedinEnabled()) {
            ServiceLinkedin serviceLinkedin = (ServiceLinkedin)ApplicationContextManager.getBean((String)"social", (String)"serviceLinkedin", ServiceLinkedin.class);
            try {
                content.addAll(serviceLinkedin.getPosts(cardBean.getLinkedinIduser(), ReseauxSociauxCardViewModelBuilder.maxProperty(cardBean.getLinkedinMax())));
            }
            catch (SocialException se) {
                LOG.error("Erreur lors du calcul du flux Linkedin pour la carte {}.", (Object)cardBean, (Object)se);
            }
        }
        return content;
    }

    protected static List<FacebookFeedBean> getContentFacebook(ReseauxSociauxCardBean cardBean) {
        ArrayList<FacebookFeedBean> content = new ArrayList<FacebookFeedBean>();
        if (cardBean.isFacebookEnabled()) {
            ServiceFacebook serviceFacebook = (ServiceFacebook)ApplicationContextManager.getBean((String)"social", (String)"serviceFacebook", ServiceFacebook.class);
            try {
                content.addAll(serviceFacebook.getPosts(cardBean.getFacebookIduser(), ReseauxSociauxCardViewModelBuilder.maxProperty(cardBean.getFacebookMax())));
            }
            catch (SocialException se) {
                LOG.error("Erreur lors du calcul du flux Facebook pour la carte {}.", (Object)cardBean, (Object)se);
            }
        }
        return content;
    }

    protected static List<TweetBean> getContentTwitter(ReseauxSociauxCardBean cardBean) {
        ArrayList<TweetBean> content = new ArrayList<TweetBean>();
        if (cardBean.isTwitterEnabled()) {
            String type = cardBean.getTwitterType();
            ServiceTwitter serviceTwitter = (ServiceTwitter)ApplicationContextManager.getBean((String)"social", (String)"serviceTwitter", ServiceTwitter.class);
            try {
                if (TwitterCardApi.TIMELINEUSER.name().equals(type)) {
                    content.addAll(serviceTwitter.getTimeline(cardBean.getTwitterTimeline(), ReseauxSociauxCardViewModelBuilder.maxProperty(cardBean.getTwitterMax()), cardBean.isTwitterEnabledRetweet()));
                } else {
                    content.addAll(serviceTwitter.getTweets(cardBean.getTwitterQuery(), ReseauxSociauxCardViewModelBuilder.maxProperty(cardBean.getTwitterMax())));
                }
            }
            catch (SocialException se) {
                LOG.error("Erreur lors du calcul du flux Twitter pour la carte {}.", (Object)cardBean, (Object)se);
            }
        }
        return content;
    }

    private static int maxProperty(String maxValue) {
        Integer max;
        int maxProperty = PropertyHelper.getPropertyAsInt((String)"social", (String)PROPRIETE_RESEAUXSOCIAUX_CARD_MAX, (int)3);
        try {
            max = Integer.valueOf(maxValue);
        }
        catch (NumberFormatException nfe) {
            max = maxProperty;
        }
        max = Math.max(1, max);
        max = Math.min(max, 20);
        return max;
    }
}

