/*
 * Decompiled with CFR 0.152.
 */
package fr.kosmos.web.projets.extensions.social.card.view.builder.impl;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kosmos.layout.card.view.model.CardViewModel;
import com.kportal.core.config.PropertyHelper;
import fr.kosmos.web.projets.extensions.social.bean.TweetBean;
import fr.kosmos.web.projets.extensions.social.card.bean.TwitterCardApi;
import fr.kosmos.web.projets.extensions.social.card.bean.TwitterCardBean;
import fr.kosmos.web.projets.extensions.social.card.view.model.TwitterCardViewModel;
import fr.kosmos.web.projets.extensions.social.exception.SocialException;
import fr.kosmos.web.projets.extensions.social.service.ServiceTwitter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitterCardViewModelBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(TwitterCardViewModelBuilder.class);
    public static final String PROPRIETE_TWITTER_CARD_MAXTWEETS = "social.twitter.card.maxtweets";
    public static final int PROPRIETE_TWITTER_CARD_MAXTWEETS_DEFAUT = 3;

    private TwitterCardViewModelBuilder() {
    }

    public static TwitterCardViewModel buildViewModel(CardViewModel cardView) {
        if (cardView != null && cardView.getCardBean() != null) {
            TwitterCardViewModel twitterCardView = new TwitterCardViewModel();
            TwitterCardBean cardBean = (TwitterCardBean)cardView.getCardBean();
            twitterCardView.setCardBean(cardView.getCardBean());
            twitterCardView.setJsonCard(cardView.getJsonCard());
            twitterCardView.setTitle(cardBean.getTitle());
            twitterCardView.setContent(TwitterCardViewModelBuilder.getFeed(cardBean));
            return twitterCardView;
        }
        LOG.error("Exception rencontr\u00e9e \u00e0 la lecture de la carte Twitter {}", (Object)cardView);
        return null;
    }

    protected static List<TweetBean> getFeed(TwitterCardBean cardBean) {
        ServiceTwitter serviceTwitter = (ServiceTwitter)ApplicationContextManager.getBean((String)"social", (String)"serviceTwitter", ServiceTwitter.class);
        int maxItem = PropertyHelper.getPropertyAsInt((String)"social", (String)PROPRIETE_TWITTER_CARD_MAXTWEETS, (int)3);
        String type = cardBean.getTwitterType();
        try {
            if (TwitterCardApi.TIMELINEUSER.name().equals(type)) {
                return serviceTwitter.getTimeline(cardBean.getTimeline(), maxItem, cardBean.isTwitterEnabledRetweet());
            }
            return serviceTwitter.getTweets(cardBean.getQuery(), maxItem);
        }
        catch (SocialException e) {
            LOG.warn("Erreur lors de la r\u00e9cup\u00e9ration des tweets de la carte {}", (Object)cardBean, (Object)e);
            throw e;
        }
    }
}

