/*
 * Decompiled with CFR 0.152.
 */
package fr.kosmos.web.projets.extensions.social.card.view.builder.impl;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kosmos.layout.card.view.model.CardViewModel;
import com.kportal.core.config.PropertyHelper;
import fr.kosmos.web.projets.extensions.social.bean.YoutubeVideoBean;
import fr.kosmos.web.projets.extensions.social.card.bean.YoutubeCardApi;
import fr.kosmos.web.projets.extensions.social.card.bean.YoutubeCardBean;
import fr.kosmos.web.projets.extensions.social.card.view.model.YoutubeCardViewModel;
import fr.kosmos.web.projets.extensions.social.exception.SocialException;
import fr.kosmos.web.projets.extensions.social.service.ServiceYoutube;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YoutubeCardViewModelBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(YoutubeCardViewModelBuilder.class);
    public static final String PROPRIETE_YOUTUBE_CARD_MAXVIDEOS = "social.youtube.card.maxvideos";
    public static final int PROPRIETE_YOUTUBE_CARD_MAXVIDEOS_DEFAUT = 3;

    private YoutubeCardViewModelBuilder() {
    }

    public static YoutubeCardViewModel buildViewModel(CardViewModel cardView) {
        if (cardView != null && cardView.getCardBean() != null) {
            YoutubeCardViewModel youtubeCardView = new YoutubeCardViewModel();
            YoutubeCardBean cardBean = (YoutubeCardBean)cardView.getCardBean();
            youtubeCardView.setCardBean(cardView.getCardBean());
            youtubeCardView.setJsonCard(cardView.getJsonCard());
            youtubeCardView.setTitle(cardBean.getTitle());
            try {
                youtubeCardView.setContent(YoutubeCardViewModelBuilder.getVideosYoutube(cardBean));
            }
            catch (SocialException e) {
                LOG.warn("Erreur lors de la r\u00e9cup\u00e9ration des vid\u00e9os de la carte {}", (Object)cardBean, (Object)e);
                throw e;
            }
            return youtubeCardView;
        }
        LOG.error("Exception rencontr\u00e9e \u00e0 la lecture de la carte (vue) Youtube {}", (Object)cardView);
        return null;
    }

    protected static List<YoutubeVideoBean> getVideosYoutube(YoutubeCardBean cardBean) {
        ServiceYoutube serviceYoutube = (ServiceYoutube)ApplicationContextManager.getBean((String)"social", (String)"serviceYoutube", ServiceYoutube.class);
        int maxVideos = PropertyHelper.getPropertyAsInt((String)"social", (String)PROPRIETE_YOUTUBE_CARD_MAXVIDEOS, (int)3);
        String type = cardBean.getType();
        List<YoutubeVideoBean> listeVideos = YoutubeCardApi.PLAYLISTITEMS.name().equals(type) ? serviceYoutube.getPlaylistVideos(cardBean.getPlaylist(), maxVideos) : serviceYoutube.getChannelVideos(cardBean.getQuery(), cardBean.getChannel(), maxVideos);
        return listeVideos;
    }
}

