/*
 * Decompiled with CFR 0.152.
 */
package fr.kosmos.web.projets.extensions.social.dao.impl;

import facebook4j.Facebook;
import facebook4j.FacebookException;
import facebook4j.FacebookFactory;
import facebook4j.Post;
import facebook4j.Reading;
import facebook4j.ResponseList;
import facebook4j.conf.ConfigurationBuilder;
import fr.kosmos.web.projets.extensions.social.bean.FacebookFeedBean;
import fr.kosmos.web.projets.extensions.social.configuration.ConfigurationFacebook;
import fr.kosmos.web.projets.extensions.social.dao.FacebookDAO;
import fr.kosmos.web.projets.extensions.social.dao.impl.mapper.FacebookFeedMapper;
import fr.kosmos.web.projets.extensions.social.exception.SocialConfigurationException;
import fr.kosmos.web.projets.extensions.social.exception.SocialException;
import fr.kosmos.web.projets.extensions.social.util.SocialUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FacebookDAOImpl
implements FacebookDAO {
    private static final Logger LOG = LoggerFactory.getLogger(FacebookDAOImpl.class);
    public static final String DEFAULT_IDUSER = "me";

    public abstract ConfigurationFacebook getConfigurationFacebook();

    private ConfigurationBuilder getConfiguration() {
        if (!SocialUtil.isFacebookEnabled()) {
            throw new SocialConfigurationException("Module 'facebook' non activ\u00e9");
        }
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        ConfigurationFacebook configurationFacebook = this.getConfigurationFacebook();
        if (configurationFacebook == null) {
            throw new SocialConfigurationException("Impossible de r\u00e9cup\u00e9rer la configuration Facebook");
        }
        String key = configurationFacebook.getConsumerKey();
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new SocialConfigurationException("Configuration de la propri\u00e9t\u00e9 'App ID' manquante");
        }
        String secret = configurationFacebook.getConsumerSecret();
        if (StringUtils.isBlank((CharSequence)secret)) {
            throw new SocialConfigurationException("Configuration de la propri\u00e9t\u00e9 'App Secret' manquante");
        }
        configurationBuilder.setOAuthAppId(key);
        configurationBuilder.setOAuthAppSecret(secret);
        return configurationBuilder;
    }

    protected Reading getPostsReading(int maxResults) {
        Reading reading = new Reading();
        reading.limit(maxResults);
        reading.fields(new String[]{"message", "message_tags", "with_tags", "link", "type", "name", "id", "created_time", "shares", "description", "from", "picture", "full_picture", "attachments", "source", "properties", "caption", "icon", "actions", "privacy", "likes.limit(1).summary(true)", "place", "status_type", "comments.limit(1).summary(true)", "object_id", "application", "updated_time", "is_published", "story"});
        reading.summary();
        return reading;
    }

    protected String getPostsUser(String idUser) {
        String idUserProcessed = StringUtils.isEmpty((CharSequence)idUser) ? DEFAULT_IDUSER : idUser;
        return idUserProcessed;
    }

    @Override
    public List<FacebookFeedBean> getPosts(String idUser, int maxResults) {
        Facebook facebook = new FacebookFactory(this.getConfiguration().setDebugEnabled(true).setPrettyDebugEnabled(true).build()).getInstance();
        try {
            LOG.debug("Configuration du jeton OAuth pour l'instance Facebook : {}", (Object)facebook);
            facebook.setOAuthPermissions("user_likes,user_posts");
            facebook.setOAuthAccessToken(facebook.getOAuthAppAccessToken());
        }
        catch (FacebookException e1) {
            throw new SocialException("Erreur \u00e0 la r\u00e9cup\u00e9ration du jeton", e1);
        }
        ArrayList<FacebookFeedBean> listeFacebookPosts = null;
        Reading reading = this.getPostsReading(maxResults);
        String idUserProcessed = this.getPostsUser(idUser);
        try {
            ResponseList facebookPosts = facebook.getPosts(idUserProcessed, reading);
            listeFacebookPosts = new ArrayList<FacebookFeedBean>(facebookPosts.size());
            for (Post post : facebookPosts) {
                listeFacebookPosts.add(FacebookFeedMapper.from(post));
            }
        }
        catch (FacebookException e) {
            throw new SocialException(e);
        }
        return listeFacebookPosts;
    }
}

