/*
 * Decompiled with CFR 0.152.
 */
package fr.kosmos.web.projets.extensions.social.dao.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.lithium.instagram4j.Instagram4j;
import com.lithium.instagram4j.InstagramError;
import com.lithium.instagram4j.model.InstagramFeedItem;
import com.lithium.instagram4j.model.InstagramPaginatingResponse;
import fr.kosmos.web.projets.extensions.social.bean.InstagramFeedBean;
import fr.kosmos.web.projets.extensions.social.configuration.ConfigurationInstagram;
import fr.kosmos.web.projets.extensions.social.dao.InstagramDAO;
import fr.kosmos.web.projets.extensions.social.dao.impl.mapper.InstagramFeedMapper;
import fr.kosmos.web.projets.extensions.social.exception.SocialConfigurationException;
import fr.kosmos.web.projets.extensions.social.exception.SocialException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InstagramDAOImpl
implements InstagramDAO {
    private static final Logger LOG = LoggerFactory.getLogger(InstagramDAOImpl.class);
    public static final String DEFAULT_IDUSER = "self";
    private final HttpClient httpClient = HttpClientBuilder.create().build();

    public abstract ConfigurationInstagram getConfigurationInstagram();

    @Override
    public List<InstagramFeedBean> getFeed(String userId, int max) {
        ConfigurationInstagram configuration = this.getConfigurationInstagram();
        if (configuration == null) {
            throw new SocialConfigurationException("Impossible de r\u00e9cup\u00e9rer la configuration Instagram");
        }
        if (StringUtils.isBlank((CharSequence)configuration.getAccessToken())) {
            if (StringUtils.isBlank((CharSequence)configuration.getClientId())) {
                throw new SocialConfigurationException("Configuration de la propri\u00e9t\u00e9 Instagram 'Client ID' manquante");
            }
            if (StringUtils.isBlank((CharSequence)configuration.getClientSecret())) {
                throw new SocialConfigurationException("Configuration de la propri\u00e9t\u00e9 Instagram 'Client Secret' manquante");
            }
            throw new SocialConfigurationException("Configuration de la propri\u00e9t\u00e9 Instagram 'AccessToken' manquante");
        }
        Instagram4j client = new Instagram4j("https://api.instagram.com", configuration.getClientId(), configuration.getClientSecret(), this.httpClient, new ObjectMapper());
        ArrayList<InstagramFeedBean> feed = null;
        try {
            InstagramPaginatingResponse userMediaRecent = client.getUserMediaRecent(configuration.getAccessToken(), this.getIdUser(userId), max, null, null, null, null);
            feed = new ArrayList<InstagramFeedBean>();
            List listeData = userMediaRecent.getData();
            if (CollectionUtils.isNotEmpty((Collection)listeData)) {
                for (InstagramFeedItem instagramFeedItem : listeData) {
                    InstagramFeedBean instagramFeedBean = InstagramFeedMapper.from(instagramFeedItem);
                    if (null == instagramFeedBean) continue;
                    feed.add(instagramFeedBean);
                }
            }
        }
        catch (InstagramError e1) {
            LOG.error("Erreur \u00e0 la r\u00e9cup\u00e9ration du flux Instagram. UserID : '{}', Access token : '{}'", (Object)userId, (Object)configuration.getAccessToken());
            throw new SocialException("Impossible de r\u00e9cup\u00e9rer le flux Instagram", e1);
        }
        return feed;
    }

    protected String getIdUser(String idUser) {
        String idUserProcessed = StringUtils.isBlank((CharSequence)idUser) ? DEFAULT_IDUSER : idUser;
        return idUserProcessed;
    }
}

