/*
 * Decompiled with CFR 0.152.
 */
package fr.kosmos.web.projets.extensions.social.dao.impl;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.scribejava.apis.LinkedInApi20;
import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.BaseApi;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth20Service;
import fr.kosmos.web.projets.extensions.social.bean.LinkedinFeedBean;
import fr.kosmos.web.projets.extensions.social.bean.LinkedinUserBean;
import fr.kosmos.web.projets.extensions.social.configuration.ConfigurationLinkedin;
import fr.kosmos.web.projets.extensions.social.dao.LinkedinDAO;
import fr.kosmos.web.projets.extensions.social.dao.impl.model.ResponseLinkedin;
import fr.kosmos.web.projets.extensions.social.dao.impl.model.UpdateContentLinkedin;
import fr.kosmos.web.projets.extensions.social.dao.impl.model.UpdateLinkedin;
import fr.kosmos.web.projets.extensions.social.exception.SocialConfigurationException;
import fr.kosmos.web.projets.extensions.social.exception.SocialExecuteException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LinkedinDAOImpl
implements LinkedinDAO {
    private static final Logger LOG = LoggerFactory.getLogger(LinkedinDAOImpl.class);
    private ObjectMapper objectMapper = new ObjectMapper();
    private boolean removeUrlProtocol;

    public abstract ConfigurationLinkedin getConfigurationLinkedin();

    public LinkedinDAOImpl() {
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public List<LinkedinFeedBean> getPosts(String companyId, int max) {
        ConfigurationLinkedin configuration = this.getConfigurationLinkedin();
        this.verifyConfiguration(configuration);
        OAuth20Service oAuth20Service = (OAuth20Service)new ServiceBuilder().apiKey(configuration.getClientId()).apiSecret(configuration.getClientSecret()).build((BaseApi)LinkedInApi20.instance());
        OAuth2AccessToken token = new OAuth2AccessToken(configuration.getAccessToken());
        OAuthRequest request = new OAuthRequest(Verb.GET, String.format("https://api.linkedin.com/v1/companies/%s/updates", companyId));
        request.addQuerystringParameter("format", "json");
        request.addQuerystringParameter("count", String.valueOf(max));
        oAuth20Service.signRequest(token, request);
        try {
            Response response = oAuth20Service.execute(request);
            LOG.debug("Flux de r\u00e9ponse pour les posts de la compagnie {} : \n {}", (Object)companyId, (Object)response.getBody());
            return this.convertFromLinkedinResponse(response);
        }
        catch (InterruptedException e) {
            LOG.error("Interruption pour la requ\u00eate de posts '{}'", (Object)companyId, (Object)e);
            throw new SocialExecuteException("Interruption", e);
        }
        catch (ExecutionException e) {
            LOG.error("Erreur d'ex\u00e9cution de la requ\u00eate de posts '{}'", (Object)companyId, (Object)e);
            throw new SocialExecuteException("Erreur d'ex\u00e9cution", e);
        }
        catch (IOException e) {
            throw new SocialExecuteException("Erreur I/O lors de l'ex\u00e9cution de la requ\u00eate Linkedin", e);
        }
    }

    protected List<LinkedinFeedBean> convertFromLinkedinResponse(Response response) {
        if (response.isSuccessful()) {
            try {
                ResponseLinkedin responseLinkedin = (ResponseLinkedin)this.objectMapper.readValue(response.getBody(), ResponseLinkedin.class);
                return this.convertToLinkedinFeedBean(responseLinkedin);
            }
            catch (IOException e) {
                throw new SocialExecuteException("Erreur \u00e0 la d\u00e9s\u00e9rialisation des donn\u00e9es Linkedin", e);
            }
        }
        LOG.error("Retour en erreur de la requ\u00eate Linkedin. {}", (Object)response);
        return Collections.emptyList();
    }

    protected List<LinkedinFeedBean> convertToLinkedinFeedBean(ResponseLinkedin responseLinkedin) {
        ArrayList<LinkedinFeedBean> linkedinFeedBeans = new ArrayList<LinkedinFeedBean>();
        if (responseLinkedin.getTotal() > 0L) {
            for (UpdateLinkedin updateLinkedin : responseLinkedin.getValues()) {
                UpdateContentLinkedin.CompanyLinkedin company;
                UpdateContentLinkedin.ShareLinkedin share;
                UpdateContentLinkedin updateContent;
                LinkedinFeedBean feedBean = new LinkedinFeedBean();
                Long numLikes = updateLinkedin.getNumLikes();
                if (numLikes != null) {
                    feedBean.setTotalLike(numLikes.intValue());
                }
                if ((updateContent = updateLinkedin.getUpdateContent()) == null) continue;
                UpdateContentLinkedin.CompanyStatusUpdateLinkedin companyStatusUpdate = updateContent.getCompanyStatusUpdate();
                if (companyStatusUpdate != null && (share = companyStatusUpdate.getShare()) != null) {
                    feedBean.setDateCreated(new Date(share.getTimestamp()));
                    feedBean.setId(share.getId());
                    feedBean.setComment(share.getComment());
                    UpdateContentLinkedin.ContentLinkedin content = share.getContent();
                    feedBean.setDescription(content.getDescription());
                    feedBean.setEyebrowUrl(content.getEyebrowUrl());
                    feedBean.setShortenedUrl(content.getShortenedUrl());
                    feedBean.setSubmittedImageUrl(this.formateUrl(content.getSubmittedImageUrl()));
                    feedBean.setSubmittedUrl(content.getSubmittedUrl());
                    feedBean.setThumbnailUrl(content.getThumbnailUrl());
                    feedBean.setTitle(content.getTitle());
                }
                if ((company = updateContent.getCompany()) != null) {
                    LinkedinUserBean userBean = new LinkedinUserBean();
                    userBean.setCompany(company.getName());
                    userBean.setId(String.valueOf(company.getId()));
                    feedBean.setCompany(userBean);
                }
                linkedinFeedBeans.add(feedBean);
            }
        }
        return linkedinFeedBeans;
    }

    protected String formateUrl(String url) {
        if (this.isRemoveUrlProtocol()) {
            return url.replaceFirst("^https?:", "");
        }
        return url;
    }

    protected void verifyConfiguration(ConfigurationLinkedin configuration) {
        if (configuration == null) {
            throw new SocialConfigurationException("Impossible de r\u00e9cup\u00e9rer la configuration Linkedin");
        }
        if (StringUtils.isBlank((CharSequence)configuration.getClientId())) {
            throw new SocialConfigurationException("Configuration de la propri\u00e9t\u00e9 Linkedin 'Client ID' manquante");
        }
        if (StringUtils.isBlank((CharSequence)configuration.getClientSecret())) {
            throw new SocialConfigurationException("Configuration de la propri\u00e9t\u00e9 Linkedin 'Client Secret' manquante");
        }
        if (StringUtils.isBlank((CharSequence)configuration.getAccessToken())) {
            throw new SocialConfigurationException("Configuration de la propri\u00e9t\u00e9 Linkedin 'Access Token' manquante");
        }
    }

    public boolean isRemoveUrlProtocol() {
        return this.removeUrlProtocol;
    }

    public void setRemoveUrlProtocol(boolean removeUrlProtocol) {
        this.removeUrlProtocol = removeUrlProtocol;
    }
}

