/*
 * Decompiled with CFR 0.152.
 */
package fr.kosmos.web.projets.extensions.social.dao.impl;

import fr.kosmos.web.projets.extensions.social.bean.TweetBean;
import fr.kosmos.web.projets.extensions.social.configuration.ConfigurationTwitter;
import fr.kosmos.web.projets.extensions.social.dao.TwitterDAO;
import fr.kosmos.web.projets.extensions.social.dao.impl.mapper.TwitterStatusMapper;
import fr.kosmos.web.projets.extensions.social.exception.SocialConfigurationException;
import fr.kosmos.web.projets.extensions.social.exception.SocialExecuteException;
import fr.kosmos.web.projets.extensions.social.util.SocialUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.ResponseList;
import twitter4j.Status;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.conf.ConfigurationBuilder;

public abstract class TwitterDAOImpl
implements TwitterDAO {
    private static final Logger LOG = LoggerFactory.getLogger(TwitterDAOImpl.class);

    private ConfigurationBuilder getConfiguration() {
        if (!SocialUtil.isTwitterEnabled()) {
            throw new SocialConfigurationException("Module 'twitter' non activ\u00e9");
        }
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.setApplicationOnlyAuthEnabled(true);
        ConfigurationTwitter configurationTwitter = this.getConfigurationTwitter();
        if (configurationTwitter == null) {
            throw new SocialConfigurationException("Impossible de r\u00e9cup\u00e9rer la configuration Twitter");
        }
        String key = configurationTwitter.getConsumerKey();
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new SocialConfigurationException("Configuration de la propri\u00e9t\u00e9 'consumer key' manquante");
        }
        String secret = configurationTwitter.getConsumerSecret();
        if (StringUtils.isBlank((CharSequence)secret)) {
            throw new SocialConfigurationException("Configuration de la propri\u00e9t\u00e9 'consumer secret' manquante");
        }
        configurationBuilder.setOAuthConsumerKey(key);
        configurationBuilder.setOAuthConsumerSecret(secret);
        return configurationBuilder;
    }

    public abstract ConfigurationTwitter getConfigurationTwitter();

    @Override
    public List<TweetBean> getTweets(String query, int maxResults) {
        ArrayList<TweetBean> listeTweets = null;
        Twitter twitter = new TwitterFactory(this.getConfiguration().build()).getInstance();
        Query queryTwitter = new Query(query);
        queryTwitter.setCount(maxResults);
        try {
            twitter.getOAuth2Token();
            QueryResult queryResult = twitter.search(queryTwitter);
            LOG.debug("R\u00e9sultats de la requ\u00eate Tweeter {} : {} tweets r\u00e9cup\u00e9r\u00e9s en {} ms", new Object[]{query, queryResult.getCount(), queryResult.getCompletedIn()});
            if (queryResult.getTweets() != null) {
                listeTweets = new ArrayList<TweetBean>(queryResult.getTweets().size());
                for (Status status : queryResult.getTweets()) {
                    listeTweets.add(TwitterStatusMapper.from(status));
                }
            }
        }
        catch (TwitterException e) {
            throw new SocialExecuteException(String.format("Exception Twitter sur la query %s", query), e);
        }
        catch (RuntimeException re) {
            throw new SocialExecuteException(String.format("Exception Runtime sur la query %s", query), re);
        }
        return listeTweets;
    }

    @Override
    public List<TweetBean> getTimeline(String user, int maxResults, boolean isEnabledRetweet) {
        ArrayList<TweetBean> listeTweets;
        block5: {
            listeTweets = null;
            Twitter twitter = new TwitterFactory(this.getConfiguration().build()).getInstance();
            try {
                twitter.getOAuth2Token();
                ResponseList listStatus = twitter.getUserTimeline(user);
                LOG.debug("R\u00e9sultats de la requ\u00eate pour le user id {} : {} tweets r\u00e9cup\u00e9r\u00e9s en {} ms", new Object[]{user, listStatus.size()});
                if (!CollectionUtils.isNotEmpty((Collection)listStatus)) break block5;
                listeTweets = new ArrayList<TweetBean>();
                for (Status status : listStatus) {
                    if ((isEnabledRetweet || !status.isRetweet()) && StringUtils.isEmpty((CharSequence)status.getInReplyToScreenName())) {
                        listeTweets.add(TwitterStatusMapper.from(status));
                    }
                    if (listeTweets.size() < maxResults) continue;
                    break;
                }
            }
            catch (TwitterException e) {
                throw new SocialExecuteException(String.format("Exception Twitter sur la query avec le user id %s", user), e);
            }
            catch (RuntimeException re) {
                throw new SocialExecuteException(String.format("Exception Runtime sur la query avec le user id %s", user), re);
            }
        }
        return listeTweets;
    }
}

