/*
 * Decompiled with CFR 0.152.
 */
package fr.kosmos.web.projets.extensions.social.dao.impl;

import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.youtube.YouTube;
import com.google.api.services.youtube.model.PlaylistItem;
import com.google.api.services.youtube.model.PlaylistItemListResponse;
import com.google.api.services.youtube.model.SearchListResponse;
import com.google.api.services.youtube.model.SearchResult;
import fr.kosmos.web.projets.extensions.social.bean.YoutubeVideoBean;
import fr.kosmos.web.projets.extensions.social.configuration.ConfigurationYoutube;
import fr.kosmos.web.projets.extensions.social.dao.YoutubeDAO;
import fr.kosmos.web.projets.extensions.social.dao.impl.mapper.YoutubePlaylistItemMapper;
import fr.kosmos.web.projets.extensions.social.dao.impl.mapper.YoutubeSearchMapper;
import fr.kosmos.web.projets.extensions.social.exception.SocialConfigurationException;
import fr.kosmos.web.projets.extensions.social.exception.SocialException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class YoutubeDAOImpl
implements YoutubeDAO {
    private static final Logger LOG = LoggerFactory.getLogger(YoutubeDAOImpl.class);
    public static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    public static final JsonFactory JSON_FACTORY = new JacksonFactory();
    private static YouTube youtube;

    public abstract ConfigurationYoutube getConfigurationYoutube();

    protected static synchronized YouTube getYoutube() {
        if (null == youtube) {
            youtube = new YouTube.Builder(HTTP_TRANSPORT, JSON_FACTORY, new HttpRequestInitializer(){

                public void initialize(HttpRequest arg0) throws IOException {
                    LOG.trace("Intialisation du client d'API Youtube : {}", (Object)this);
                }
            }).setApplicationName("social-extension").build();
        }
        return youtube;
    }

    @Override
    public List<YoutubeVideoBean> getChannelVideos(String query, String channel, int maxVideos) {
        ConfigurationYoutube configuration = this.getConfigurationYoutube();
        if (StringUtils.isEmpty((CharSequence)configuration.getApiKey())) {
            throw new SocialConfigurationException("Cl\u00e9 d'API non renseign\u00e9e");
        }
        try {
            YouTube.Search.List search = YoutubeDAOImpl.getYoutube().search().list("id,snippet");
            search.setKey(configuration.getApiKey());
            if (StringUtils.isNotEmpty((CharSequence)query)) {
                search.setQ(query);
            }
            if (StringUtils.isNotEmpty((CharSequence)channel)) {
                search.setChannelId(channel);
            }
            search.setOrder("date");
            search.setType("video");
            search.setFields("items(id,kind,snippet),kind");
            search.setMaxResults(Long.valueOf(maxVideos));
            SearchListResponse searchResponse = (SearchListResponse)search.execute();
            List searchResultList = searchResponse.getItems();
            return YoutubeDAOImpl.fromSearchResult(searchResultList);
        }
        catch (IOException e) {
            throw new SocialException(e);
        }
    }

    @Override
    public List<YoutubeVideoBean> getPlaylistVideos(String playlist, int maxVideos) {
        ConfigurationYoutube configuration = this.getConfigurationYoutube();
        if (StringUtils.isEmpty((CharSequence)configuration.getApiKey())) {
            throw new SocialConfigurationException("Cl\u00e9 d'API non renseign\u00e9e");
        }
        try {
            YouTube.PlaylistItems.List playlistItems = YoutubeDAOImpl.getYoutube().playlistItems().list("id,snippet");
            playlistItems.setKey(configuration.getApiKey());
            playlistItems.setFields("items/snippet");
            if (StringUtils.isNotEmpty((CharSequence)playlist)) {
                playlistItems.setPlaylistId(playlist);
            }
            playlistItems.setMaxResults(Long.valueOf(maxVideos));
            PlaylistItemListResponse playlistResponse = (PlaylistItemListResponse)playlistItems.execute();
            List searchResultList = playlistResponse.getItems();
            return YoutubeDAOImpl.fromPlaylistResult(searchResultList);
        }
        catch (IOException e) {
            throw new SocialException(e);
        }
    }

    protected static List<YoutubeVideoBean> fromSearchResult(List<SearchResult> searchResultList) {
        ArrayList<YoutubeVideoBean> listeVideos = null;
        if (null != searchResultList) {
            listeVideos = new ArrayList<YoutubeVideoBean>(searchResultList.size());
            for (SearchResult searchResult : searchResultList) {
                YoutubeVideoBean video = YoutubeSearchMapper.from(searchResult);
                if (null == video) continue;
                listeVideos.add(video);
            }
        }
        return listeVideos;
    }

    protected static List<YoutubeVideoBean> fromPlaylistResult(List<PlaylistItem> playListItemList) {
        ArrayList<YoutubeVideoBean> listeVideos = null;
        if (null != playListItemList) {
            listeVideos = new ArrayList<YoutubeVideoBean>(playListItemList.size());
            for (PlaylistItem playlistItem : playListItemList) {
                YoutubeVideoBean video = YoutubePlaylistItemMapper.from(playlistItem);
                if (null == video) continue;
                listeVideos.add(video);
            }
        }
        return listeVideos;
    }
}

