/*
 * Decompiled with CFR 0.152.
 */
package fr.kosmos.web.projets.extensions.social.dao.impl.mapper;

import facebook4j.Tag;
import fr.kosmos.web.projets.extensions.social.bean.FacebookTagBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FacebookTagMapper {
    private FacebookTagMapper() {
    }

    public static List<FacebookTagBean> from(Collection<Tag> tags) {
        List<FacebookTagBean> liste;
        if (tags != null) {
            liste = new ArrayList<FacebookTagBean>(tags.size());
            for (Tag tag : tags) {
                liste.add(FacebookTagMapper.from(tag));
            }
        } else {
            liste = Collections.emptyList();
        }
        return liste;
    }

    public static Map<String, List<FacebookTagBean>> from(Map<String, Tag[]> mapTags) {
        HashMap<String, List<FacebookTagBean>> map = new HashMap<String, List<FacebookTagBean>>();
        for (Map.Entry<String, Tag[]> entryTag : mapTags.entrySet()) {
            List liste;
            Tag[] tags = entryTag.getValue();
            if (tags != null) {
                liste = new ArrayList(tags.length);
                for (Tag tag : tags) {
                    liste.add(FacebookTagMapper.from(tag));
                }
            } else {
                liste = Collections.emptyList();
            }
            map.put(entryTag.getKey(), liste);
        }
        return map;
    }

    public static FacebookTagBean from(Tag tag) {
        if (null != tag) {
            FacebookTagBean facebookTagBean = new FacebookTagBean();
            facebookTagBean.setDateCreated(tag.getCreatedTime());
            facebookTagBean.setOffset(tag.getOffset());
            facebookTagBean.setCoordX(tag.getX());
            facebookTagBean.setCoordY(tag.getY());
            facebookTagBean.setId(tag.getId());
            facebookTagBean.setName(tag.getName());
            facebookTagBean.setType(tag.getType());
            return facebookTagBean;
        }
        return null;
    }
}

