/*
 * Decompiled with CFR 0.152.
 */
package fr.kosmos.web.projets.extensions.social.dao.impl.mapper;

import com.lithium.instagram4j.model.InstagramCaption;
import com.lithium.instagram4j.model.InstagramFeedItem;
import com.lithium.instagram4j.model.InstagramMedia;
import com.lithium.instagram4j.model.InstagramUser;
import fr.kosmos.web.projets.extensions.social.bean.InstagramCaptionBean;
import fr.kosmos.web.projets.extensions.social.bean.InstagramFeedBean;
import fr.kosmos.web.projets.extensions.social.bean.InstagramUserBean;
import fr.kosmos.web.projets.extensions.social.dao.impl.mapper.InstagramMediaMapper;
import java.util.Date;
import java.util.Map;

public class InstagramFeedMapper {
    private InstagramFeedMapper() {
    }

    public static InstagramFeedBean from(InstagramFeedItem instagramFeedItem) {
        InstagramUser user;
        InstagramCaption caption;
        InstagramFeedBean instagramFeedBean = new InstagramFeedBean();
        instagramFeedBean.setDateCreated(new Date(1000L * instagramFeedItem.getCreatedTimeSecondsSinceEpoch()));
        instagramFeedBean.setId(instagramFeedItem.getId());
        instagramFeedBean.setLink(instagramFeedItem.getLink());
        instagramFeedBean.setMediaType(instagramFeedItem.getType());
        instagramFeedBean.setTags(instagramFeedItem.getTags());
        Map images = instagramFeedItem.getImages();
        if (null != images) {
            instagramFeedBean.setStdImage(InstagramMediaMapper.from((InstagramMedia)instagramFeedItem.getImages().get("standard_resolution")));
            instagramFeedBean.setThumbImage(InstagramMediaMapper.from((InstagramMedia)instagramFeedItem.getImages().get("thumbnail")));
        }
        if (null != (caption = instagramFeedItem.getCaption())) {
            InstagramCaptionBean instagramCaption = new InstagramCaptionBean();
            instagramCaption.setDateCreated(new Date(1000L * caption.getCreatedTimeSecondsSinceEpoch()));
            instagramCaption.setText(caption.getText());
            instagramCaption.setId(caption.getId());
            instagramFeedBean.setCaption(instagramCaption);
        }
        if (null != (user = instagramFeedItem.getUser())) {
            InstagramUserBean userBean = new InstagramUserBean();
            userBean.setId(user.getId());
            userBean.setFullName(user.getFullName());
            userBean.setUserName(user.getUserName());
            userBean.setProfilePictureUrl(user.getProfilePictureUrl());
            instagramFeedBean.setUser(userBean);
        }
        return instagramFeedBean;
    }
}

