/*
 * Decompiled with CFR 0.152.
 */
package fr.kosmos.web.projets.extensions.social.dao.impl.mapper;

import com.google.api.services.youtube.model.PlaylistItem;
import com.google.api.services.youtube.model.PlaylistItemSnippet;
import com.google.api.services.youtube.model.ResourceId;
import com.google.api.services.youtube.model.Thumbnail;
import fr.kosmos.web.projets.extensions.social.bean.YoutubeVideoBean;
import java.util.Date;

public class YoutubePlaylistItemMapper {
    private YoutubePlaylistItemMapper() {
    }

    public static YoutubeVideoBean from(PlaylistItem playlistItem) {
        YoutubeVideoBean youtubeVideoBean = null;
        PlaylistItemSnippet snippet = playlistItem.getSnippet();
        ResourceId rId = snippet.getResourceId();
        if ("youtube#video".equals(rId.getKind())) {
            youtubeVideoBean = new YoutubeVideoBean();
            Thumbnail thumbnail = snippet.getThumbnails().getDefault();
            youtubeVideoBean.setUrlThumbnail(thumbnail.getUrl());
            youtubeVideoBean.setTitle(snippet.getTitle());
            youtubeVideoBean.setDateCreated(new Date(snippet.getPublishedAt().getValue()));
            youtubeVideoBean.setId(rId.getVideoId());
            youtubeVideoBean.setDescription(snippet.getDescription());
            youtubeVideoBean.setChannelId(snippet.getChannelId());
            youtubeVideoBean.setChannelTitle(snippet.getChannelTitle());
        }
        return youtubeVideoBean;
    }
}

