/*
 * Decompiled with CFR 0.152.
 */
package fr.kosmos.web.projets.extensions.social.manager;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kosmos.usinesite.template.bean.TemplateSite;
import com.kosmos.usinesite.template.bean.impl.TemplateSiteImpl;
import com.kosmos.usinesite.template.property.bean.TemplateSiteProperty;
import com.kosmos.usinesite.template.property.bean.impl.TemplateSitePropertyString;
import com.kosmos.usinesite.template.service.ServiceTemplateSite;
import com.kportal.extension.module.AbstractBeanManager;
import fr.kosmos.web.projets.extensions.social.template.property.bean.impl.TemplateSitePropertyOAuth;
import fr.kosmos.web.projets.extensions.social.util.SocialUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocialBeanManager
extends AbstractBeanManager {
    private static final Logger LOG = LoggerFactory.getLogger(SocialBeanManager.class);

    public void refresh() {
        Map listeServiceTemplate = ApplicationContextManager.getAllBeansOfType(ServiceTemplateSite.class);
        Collection<TemplateSite> templatesSites = MapUtils.isNotEmpty((Map)listeServiceTemplate) ? SocialBeanManager.getTemplateSites(listeServiceTemplate) : null;
        if (CollectionUtils.isNotEmpty(templatesSites)) {
            this.refreshTwitter(templatesSites, SocialUtil.isTwitterEnabled());
            this.refreshFacebook(templatesSites, SocialUtil.isFacebookEnabled());
            this.refreshInstagram(templatesSites, SocialUtil.isInstagramEnabled());
            this.refreshYoutube(templatesSites, SocialUtil.isYoutubeEnabled());
            this.refreshLinkedin(templatesSites, SocialUtil.isLinkedinEnabled());
        } else {
            LOG.warn("Aucun param\u00e9trage du template n'a \u00e9t\u00e9 modifi\u00e9 li\u00e9 \u00e0 l'extension 'social' car aucun template de site n'a \u00e9t\u00e9 trouv\u00e9");
        }
    }

    protected void refreshTwitter(Collection<TemplateSite> templatesSites, boolean moduleActive) {
        if (ApplicationContextManager.containsBean((String)"social", (String)"twitterConsumerKey") && ApplicationContextManager.containsBean((String)"social", (String)"twitterConsumerSecret")) {
            TemplateSitePropertyString consumerKey = (TemplateSitePropertyString)ApplicationContextManager.getBean((String)"social", (String)"twitterConsumerKey", TemplateSitePropertyString.class);
            TemplateSitePropertyString consumerSecret = (TemplateSitePropertyString)ApplicationContextManager.getBean((String)"social", (String)"twitterConsumerSecret", TemplateSitePropertyString.class);
            for (TemplateSite templateSite : templatesSites) {
                SocialBeanManager.refreshPropriete(templateSite, (TemplateSiteProperty)consumerKey, moduleActive);
                SocialBeanManager.refreshPropriete(templateSite, (TemplateSiteProperty)consumerSecret, moduleActive);
            }
        } else {
            LOG.error("Impossible d'initialiser les propri\u00e9t\u00e9s Twitter de l'extension 'social', pas de propri\u00e9t\u00e9s correspondantes dans la configuration de l'extension");
        }
    }

    protected void refreshFacebook(Collection<TemplateSite> templatesSites, boolean moduleActive) {
        if (ApplicationContextManager.containsBean((String)"social", (String)"facebookConsumerKey") && ApplicationContextManager.containsBean((String)"social", (String)"facebookConsumerSecret")) {
            TemplateSitePropertyString consumerKey = (TemplateSitePropertyString)ApplicationContextManager.getBean((String)"social", (String)"facebookConsumerKey", TemplateSitePropertyString.class);
            TemplateSitePropertyString consumerSecret = (TemplateSitePropertyString)ApplicationContextManager.getBean((String)"social", (String)"facebookConsumerSecret", TemplateSitePropertyString.class);
            for (TemplateSite templateSite : templatesSites) {
                SocialBeanManager.refreshPropriete(templateSite, (TemplateSiteProperty)consumerKey, moduleActive);
                SocialBeanManager.refreshPropriete(templateSite, (TemplateSiteProperty)consumerSecret, moduleActive);
            }
        } else {
            LOG.error("Impossible d'initialiser les propri\u00e9t\u00e9s Facebook de l'extension 'social', pas de propri\u00e9t\u00e9s correspondantes dans la configuration de l'extension");
        }
    }

    protected void refreshInstagram(Collection<TemplateSite> templatesSites, boolean moduleActive) {
        if (ApplicationContextManager.containsBean((String)"social", (String)"instagramClientId")) {
            TemplateSitePropertyString clientId = (TemplateSitePropertyString)ApplicationContextManager.getBean((String)"social", (String)"instagramClientId", TemplateSitePropertyString.class);
            TemplateSitePropertyString clientSecret = (TemplateSitePropertyString)ApplicationContextManager.getBean((String)"social", (String)"instagramClientSecret", TemplateSitePropertyString.class);
            TemplateSitePropertyOAuth accessToken = (TemplateSitePropertyOAuth)((Object)ApplicationContextManager.getBean((String)"social", (String)"instagramAccessToken", TemplateSitePropertyOAuth.class));
            for (TemplateSite templateSite : templatesSites) {
                SocialBeanManager.refreshPropriete(templateSite, (TemplateSiteProperty)clientId, moduleActive);
                SocialBeanManager.refreshPropriete(templateSite, (TemplateSiteProperty)clientSecret, moduleActive);
                SocialBeanManager.refreshPropriete(templateSite, (TemplateSiteProperty)accessToken, moduleActive);
            }
        } else {
            LOG.error("Impossible d'initialiser les propri\u00e9t\u00e9s Instagram de l'extension 'social', pas de propri\u00e9t\u00e9s correspondantes dans la configuration de l'extension");
        }
    }

    protected void refreshLinkedin(Collection<TemplateSite> templatesSites, boolean moduleActive) {
        if (ApplicationContextManager.containsBean((String)"social", (String)"linkedinClientId")) {
            TemplateSitePropertyString clientId = (TemplateSitePropertyString)ApplicationContextManager.getBean((String)"social", (String)"linkedinClientId", TemplateSitePropertyString.class);
            TemplateSitePropertyString clientSecret = (TemplateSitePropertyString)ApplicationContextManager.getBean((String)"social", (String)"linkedinClientSecret", TemplateSitePropertyString.class);
            TemplateSitePropertyOAuth accessToken = (TemplateSitePropertyOAuth)((Object)ApplicationContextManager.getBean((String)"social", (String)"linkedinAccessToken", TemplateSitePropertyOAuth.class));
            for (TemplateSite templateSite : templatesSites) {
                SocialBeanManager.refreshPropriete(templateSite, (TemplateSiteProperty)clientId, moduleActive);
                SocialBeanManager.refreshPropriete(templateSite, (TemplateSiteProperty)clientSecret, moduleActive);
                SocialBeanManager.refreshPropriete(templateSite, (TemplateSiteProperty)accessToken, moduleActive);
            }
        } else {
            LOG.error("Impossible d'initialiser les propri\u00e9t\u00e9s Linkedin de l'extension 'social', pas de propri\u00e9t\u00e9s correspondantes dans la configuration de l'extension");
        }
    }

    protected void refreshYoutube(Collection<TemplateSite> templatesSites, boolean moduleActive) {
        if (ApplicationContextManager.containsBean((String)"social", (String)"youtubeApiKey")) {
            TemplateSitePropertyString apiKey = (TemplateSitePropertyString)ApplicationContextManager.getBean((String)"social", (String)"youtubeApiKey", TemplateSitePropertyString.class);
            for (TemplateSite templateSite : templatesSites) {
                SocialBeanManager.refreshPropriete(templateSite, (TemplateSiteProperty)apiKey, moduleActive);
            }
        } else {
            LOG.error("Impossible d'initialiser les propri\u00e9t\u00e9s Youtube de l'extension 'social', pas de propri\u00e9t\u00e9s correspondantes dans la configuration de l'extension");
        }
    }

    private static void refreshPropriete(TemplateSite templateSite, TemplateSiteProperty property, boolean extensionActivee) {
        TemplateSiteProperty proprietePresente = templateSite.getProprieteComplementaire(property.getCode());
        List proprietesTemplate = templateSite.getListeProprietesComplementaires();
        if (proprietePresente == null) {
            if (extensionActivee) {
                LOG.info("Ajout de la propri\u00e9t\u00e9 : '{}' au template '{}'", (Object)property.getCode(), (Object)templateSite.getCode());
                proprietesTemplate.add(property);
                ((TemplateSiteImpl)templateSite).mapProprietesComplementaires.put(property.getCode(), property);
            } else {
                LOG.debug("Extension 'social' d\u00e9sactiv\u00e9e, pas d'ajout de la propri\u00e9t\u00e9 '{}' au template '{}'", (Object)property.getCode(), (Object)templateSite.getCode());
            }
        } else if (extensionActivee) {
            LOG.debug("La propri\u00e9t\u00e9 '{}' est d\u00e9j\u00e0 pr\u00e9sente dans le template '{}'. Pas de modification des propri\u00e9t\u00e9s", (Object)property.getCode(), (Object)templateSite.getCode());
        } else {
            LOG.info("Suppression de la propri\u00e9t\u00e9 : '{}' du template '{}'", (Object)property.getCode(), (Object)templateSite.getCode());
            proprietesTemplate.remove(proprietePresente);
            ((TemplateSiteImpl)templateSite).mapProprietesComplementaires.remove(property.getCode());
        }
    }

    private static Collection<TemplateSite> getTemplateSites(Map<String, ServiceTemplateSite> mapTemplateSite) {
        ArrayList<TemplateSite> templatesSites = new ArrayList<TemplateSite>();
        for (Map.Entry<String, ServiceTemplateSite> serviceTemplateItem : mapTemplateSite.entrySet()) {
            try {
                ServiceTemplateSite serviceTemplate = serviceTemplateItem.getValue();
                if (serviceTemplate == null || serviceTemplate.getListeTemplatesSite() == null) continue;
                templatesSites.addAll(serviceTemplate.getListeTemplatesSite());
            }
            catch (Exception e) {
                LOG.error(String.format("Impossible d'ajouter les templates du bean '%s'", serviceTemplateItem.getKey()), (Throwable)e);
            }
        }
        return templatesSites;
    }
}

