/*
 * Decompiled with CFR 0.152.
 */
package fr.kosmos.web.projets.extensions.social.service.impl;

import com.kdecole.cache.aspect.TempCacheFlush;
import com.kdecole.cache.aspect.TempCacheGet;
import fr.kosmos.web.projets.extensions.social.bean.TweetBean;
import fr.kosmos.web.projets.extensions.social.dao.TwitterDAO;
import fr.kosmos.web.projets.extensions.social.exception.SocialConfigurationException;
import fr.kosmos.web.projets.extensions.social.service.ServiceTwitter;
import fr.kosmos.web.projets.extensions.social.util.SocialUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ServiceTwitterImpl
implements ServiceTwitter {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceTwitterImpl.class);
    @Autowired
    private TwitterDAO twitterDAO;

    @Override
    @TempCacheFlush(key="ServiceTwitter.getTweets", numberOfParameterForKeyGeneration=2, contextual=false)
    public void flushCache() {
        LOG.debug("Suppression de toutes les entr\u00e9e du cache 'ServiceTwitter.getTweets'");
    }

    @Override
    @TempCacheGet(key="ServiceTwitter.getTweets", numberOfParameterForKeyGeneration=2, duration=TempCacheGet.DurationType.SHORT, contextual=false)
    public List<TweetBean> getTweets(String query, int maxResults) {
        if (SocialUtil.isTwitterEnabled()) {
            return this.twitterDAO.getTweets(query, maxResults);
        }
        throw new SocialConfigurationException(String.format("Module 'twitter' d\u00e9sactiv\u00e9, aucune r\u00e9cup\u00e9ration de tweets n'est effectu\u00e9e pour la requ\u00eate '%s'", query));
    }

    public final TwitterDAO getTwitterDAO() {
        return this.twitterDAO;
    }

    public final void setTwitterDAO(TwitterDAO twitterDAO) {
        this.twitterDAO = twitterDAO;
    }

    @Override
    @TempCacheGet(key="ServiceTwitter.getTweetTimeline", numberOfParameterForKeyGeneration=2, duration=TempCacheGet.DurationType.SHORT, contextual=false)
    public List<TweetBean> getTimeline(String user, int maxResults, boolean isEnabledRetweet) {
        if (SocialUtil.isTwitterEnabled()) {
            return this.twitterDAO.getTimeline(user, maxResults, isEnabledRetweet);
        }
        throw new SocialConfigurationException(String.format("Module 'twitter' d\u00e9sactiv\u00e9, aucune r\u00e9cup\u00e9ration de tweets n'est effectu\u00e9e pour l'user id '%s'", user));
    }
}

