/*
 * Decompiled with CFR 0.152.
 */
package fr.kosmos.web.projets.extensions.social.service.impl;

import com.kdecole.cache.aspect.TempCacheFlush;
import com.kdecole.cache.aspect.TempCacheGet;
import fr.kosmos.web.projets.extensions.social.bean.YoutubeVideoBean;
import fr.kosmos.web.projets.extensions.social.dao.YoutubeDAO;
import fr.kosmos.web.projets.extensions.social.service.ServiceYoutube;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ServiceYoutubeImpl
implements ServiceYoutube {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceYoutubeImpl.class);
    @Autowired
    private YoutubeDAO youtubeDAO;

    @Override
    @TempCacheGet(key="ServiceYoutube.getChannelVideos", numberOfParameterForKeyGeneration=3, contextual=false)
    public List<YoutubeVideoBean> getChannelVideos(String query, String channel, int maxResults) {
        return this.youtubeDAO.getChannelVideos(query, channel, maxResults);
    }

    @Override
    @TempCacheGet(key="ServiceYoutube.getPlaylistVideos", numberOfParameterForKeyGeneration=2, contextual=false)
    public List<YoutubeVideoBean> getPlaylistVideos(String playlist, int maxResults) {
        return this.youtubeDAO.getPlaylistVideos(playlist, maxResults);
    }

    @Override
    public void flushCache() {
        this.flushCacheChannelVideos();
        this.flushCachePlaylistVideos();
    }

    @TempCacheFlush(key="ServiceYoutube.getChannelVideos", numberOfParameterForKeyGeneration=3, contextual=false)
    protected void flushCacheChannelVideos() {
        LOG.debug("Suppression de toutes les entr\u00e9e du cache 'ServiceYoutube.getChannelVideos'");
    }

    @TempCacheFlush(key="ServiceYoutube.getPlaylistVideos", numberOfParameterForKeyGeneration=3, contextual=false)
    protected void flushCachePlaylistVideos() {
        LOG.debug("Suppression de toutes les entr\u00e9e du cache 'ServiceYoutube.getPlaylistVideos'");
    }

    public YoutubeDAO getYoutubeDAO() {
        return this.youtubeDAO;
    }

    public void setYoutubeDAO(YoutubeDAO youtubeDAO) {
        this.youtubeDAO = youtubeDAO;
    }
}

