/*
 * Decompiled with CFR 0.152.
 */
package fr.kosmos.web.projets.extensions.social.servlet;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.database.OMContext;
import com.kosmos.usinesite.template.property.bean.impl.TemplateSitePropertyString;
import com.kportal.servlet.ExtensionServlet;
import com.univ.multisites.InfosSite;
import com.univ.multisites.Site;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.URLResolver;
import fr.kosmos.web.projets.extensions.social.util.SocialUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="oAuthAuthorizeServlet", urlPatterns={"/servlet/fr.kosmos.web.projets.extensions.social.servlet.OAuthAuthorizeServlet"}, loadOnStartup=0)
public class OAuthAuthorizeServlet
extends ExtensionServlet {
    private static final long serialVersionUID = -4358046789307266611L;
    private static final Logger LOG = LoggerFactory.getLogger(OAuthAuthorizeServlet.class);
    public static final String URL = "/servlet/fr.kosmos.web.projets.extensions.social.servlet.OAuthAuthorizeServlet";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        if (StringUtils.isEmpty((CharSequence)ctx.getCode())) {
            LOG.debug("Il faut n\u00e9cessairement \u00eatre connect\u00e9 pour faire r\u00e9cup\u00e9rer un jeton");
            OAuthAuthorizeServlet.sendError(response, 401);
        } else {
            String redirectUriEncoded;
            String urlAuthorize;
            TemplateSitePropertyString clientIdProperty;
            String domOrigin = StringUtils.defaultString((String)request.getParameter("domorigin"));
            InfosSite infosSite = Site.renvoyerItemSite((String)request.getParameter("code"));
            String service = StringUtils.defaultString((String)request.getParameter("service"));
            if (StringUtils.isEmpty((CharSequence)service) || "instagram".equals(service)) {
                if (!SocialUtil.isInstagramEnabled()) {
                    LOG.debug("Instagram n'est pas activ\u00e9, impossible de r\u00e9cup\u00e9rer les informations de compte");
                    OAuthAuthorizeServlet.sendError(response, 406);
                    return;
                }
                clientIdProperty = (TemplateSitePropertyString)ApplicationContextManager.getBean((String)"social", (String)"instagramClientId", TemplateSitePropertyString.class);
                String clientId = StringUtils.defaultString((String)infosSite.getProprieteComplementaireString(clientIdProperty.getCode()), (String)clientIdProperty.getValeurDefaut());
                urlAuthorize = String.format("https://instagram.com/oauth/authorize/?client_id=%s&response_type=code&scope=public_content&redirect_uri=", clientId);
            } else if ("linkedin".equals(service)) {
                if (!SocialUtil.isLinkedinEnabled()) {
                    LOG.debug("Linkedin n'est pas activ\u00e9, impossible de r\u00e9cup\u00e9rer les informations de compte");
                    OAuthAuthorizeServlet.sendError(response, 406);
                    return;
                }
                clientIdProperty = (TemplateSitePropertyString)ApplicationContextManager.getBean((String)"social", (String)"linkedinClientId", TemplateSitePropertyString.class);
                String clientId = StringUtils.defaultString((String)infosSite.getProprieteComplementaireString(clientIdProperty.getCode()), (String)clientIdProperty.getValeurDefaut());
                urlAuthorize = String.format("https://www.linkedin.com/oauth/v2/authorization/?client_id=%s&response_type=code&state=ksup&scope=rw_company_admin r_basicprofile&redirect_uri=", clientId);
            } else {
                LOG.error("Service {} non support\u00e9", (Object)service);
                OAuthAuthorizeServlet.sendError(response, 406);
                return;
            }
            String redirectUri = URLResolver.getAbsoluteUrl((String)String.format("%s?domorigin=%s&service=%s", "/servlet/fr.kosmos.web.projets.extensions.social.servlet.OAuthCallbackServlet", domOrigin, service), (OMContext)ctx, (InfosSite)infosSite);
            try {
                redirectUriEncoded = URLEncoder.encode(redirectUri, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                LOG.error("Erreur d'encodage en UTF-8 de la cha\u00eene {}", (Object)redirectUri, (Object)uee);
                OAuthAuthorizeServlet.sendError(response, 500);
                return;
            }
            String url = urlAuthorize + redirectUriEncoded;
            try {
                response.sendRedirect(url);
            }
            catch (IOException ioe) {
                LOG.error("Impossible de faire la redirection vers l'URL {}", (Object)url, (Object)ioe);
                OAuthAuthorizeServlet.sendError(response, 500);
            }
        }
    }

    public static void sendError(HttpServletResponse response, int error) {
        try {
            response.sendError(error);
        }
        catch (IOException e) {
            LOG.error("Erreur I/O sur l'envoi d'erreurs", (Throwable)e);
        }
    }
}

