/*
 * Decompiled with CFR 0.152.
 */
package fr.kosmos.web.projets.extensions.social.servlet;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.scribejava.apis.LinkedInApi20;
import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.BaseApi;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.database.OMContext;
import com.kosmos.usinesite.template.property.bean.impl.TemplateSitePropertyString;
import com.kportal.extension.ExtensionHelper;
import com.kportal.servlet.ExtensionServlet;
import com.lithium.instagram4j.Instagram4j;
import com.lithium.instagram4j.InstagramError;
import com.lithium.instagram4j.model.InstagramAccessTokenResponse;
import com.univ.multisites.InfosSite;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.URLResolver;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="oAuthCallbackServlet", urlPatterns={"/servlet/fr.kosmos.web.projets.extensions.social.servlet.OAuthCallbackServlet"}, loadOnStartup=0)
public class OAuthCallbackServlet
extends ExtensionServlet {
    public static final String URL = "/servlet/fr.kosmos.web.projets.extensions.social.servlet.OAuthCallbackServlet";
    private static final Logger LOG = LoggerFactory.getLogger(OAuthCallbackServlet.class);
    private static final long serialVersionUID = -4731613467052507928L;
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final HttpClient HTTP_CLIENT = new DefaultHttpClient();

    protected void doGet(HttpServletRequest paramHttpServletRequest, HttpServletResponse paramHttpServletResponse) throws ServletException, IOException {
        this.process(paramHttpServletRequest, paramHttpServletResponse);
    }

    private void process(HttpServletRequest paramHttpServletRequest, HttpServletResponse paramHttpServletResponse) {
        String clientId;
        TemplateSitePropertyString clientIdProperty;
        String service = paramHttpServletRequest.getParameter("service");
        String code = paramHttpServletRequest.getParameter("code");
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        InfosSite infosSite = ctx.getInfosSite();
        String domorigin = paramHttpServletRequest.getParameter("domorigin");
        if (StringUtils.isBlank((CharSequence)service) || "instagram".equals(service)) {
            clientIdProperty = (TemplateSitePropertyString)ApplicationContextManager.getBean((String)"social", (String)"instagramClientId", TemplateSitePropertyString.class);
            clientId = StringUtils.defaultString((String)infosSite.getProprieteComplementaireString(clientIdProperty.getCode()), (String)clientIdProperty.getValeurDefaut());
            TemplateSitePropertyString clientSecretProperty = (TemplateSitePropertyString)ApplicationContextManager.getBean((String)"social", (String)"instagramClientSecret", TemplateSitePropertyString.class);
            String clientSecret = StringUtils.defaultString((String)infosSite.getProprieteComplementaireString(clientSecretProperty.getCode()), (String)clientSecretProperty.getValeurDefaut());
            Instagram4j instagram4j = new Instagram4j("https://api.instagram.com", clientId, clientSecret, HTTP_CLIENT, OBJECT_MAPPER);
            try {
                String redirectUri = URLResolver.getAbsoluteUrl((String)String.format("%s?domorigin=%s&service=%s", URL, domorigin, service), (OMContext)ctx, (InfosSite)infosSite);
                InstagramAccessTokenResponse tokenResponse = instagram4j.getAccessToken(redirectUri, code);
                paramHttpServletRequest.setAttribute("accessToken", (Object)tokenResponse.getAccessToken());
                paramHttpServletRequest.setAttribute("domOrigin", (Object)domorigin);
            }
            catch (InstagramError e) {
                LOG.error("Erreur lors de la r\u00e9cup\u00e9ration du jeton", (Throwable)e);
                try {
                    paramHttpServletResponse.sendError(500);
                }
                catch (IOException ioe) {
                    LOG.error("Erreur I/O sur l'envoi d'erreurs", (Throwable)ioe);
                }
                return;
            }
            catch (Exception e) {
                LOG.error("Erreur lors de la r\u00e9cup\u00e9ration du jeton", (Throwable)e);
                throw e;
            }
        }
        if ("linkedin".equals(service)) {
            clientIdProperty = (TemplateSitePropertyString)ApplicationContextManager.getBean((String)"social", (String)"linkedinClientId", TemplateSitePropertyString.class);
            clientId = StringUtils.defaultString((String)infosSite.getProprieteComplementaireString(clientIdProperty.getCode()), (String)clientIdProperty.getValeurDefaut());
            TemplateSitePropertyString clientSecretProperty = (TemplateSitePropertyString)ApplicationContextManager.getBean((String)"social", (String)"linkedinClientSecret", TemplateSitePropertyString.class);
            String clientSecret = StringUtils.defaultString((String)infosSite.getProprieteComplementaireString(clientSecretProperty.getCode()), (String)clientSecretProperty.getValeurDefaut());
            String redirectUri = URLResolver.getAbsoluteUrl((String)String.format("%s?domorigin=%s&service=%s", URL, domorigin, service), (OMContext)ctx, (InfosSite)infosSite);
            OAuth20Service serviceLinkedin = (OAuth20Service)new ServiceBuilder().apiKey(clientId).apiSecret(clientSecret).callback(redirectUri).build((BaseApi)LinkedInApi20.instance());
            try {
                OAuth2AccessToken auth2AccessToken = serviceLinkedin.getAccessToken(code);
                String accessToken = auth2AccessToken.getAccessToken();
                paramHttpServletRequest.setAttribute("accessToken", (Object)accessToken);
                paramHttpServletRequest.setAttribute("domOrigin", (Object)domorigin);
            }
            catch (IOException e) {
                LOG.error("Erreur I/O sur l'envoi d'erreurs", (Throwable)e);
            }
            catch (InterruptedException e) {
                LOG.error("Erreur d'interruption", (Throwable)e);
            }
            catch (ExecutionException e) {
                LOG.error("Erreur d'ex\u00e9cution", (Throwable)e);
            }
        } else {
            LOG.error("Service {} non support\u00e9", (Object)service);
        }
        RequestDispatcher requestDispatcher = paramHttpServletRequest.getRequestDispatcher(ExtensionHelper.getTemplateExtension((String)"social", (String)"/WEB-INF/jsp/social/oauth2/callback.jsp", (boolean)false));
        try {
            requestDispatcher.forward((ServletRequest)paramHttpServletRequest, (ServletResponse)paramHttpServletResponse);
        }
        catch (IOException | ServletException e) {
            LOG.error("Erreur sur le forward", e);
        }
    }

    protected void doPost(HttpServletRequest paramHttpServletRequest, HttpServletResponse paramHttpServletResponse) throws ServletException, IOException {
        try {
            paramHttpServletResponse.sendError(405);
        }
        catch (IOException e) {
            LOG.error("Erreur I/O sur l'envoi d'erreurs", (Throwable)e);
        }
    }
}

