/*
 * Decompiled with CFR 0.152.
 */
package fr.kosmos.web.projets.extensions.social.tag.interpreteur;

import com.kportal.tag.interpreteur.impl.DefaultInterpreteurTemplateTag;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import fr.kosmos.web.projets.extensions.social.bean.FacebookFeedBean;
import fr.kosmos.web.projets.extensions.social.exception.SocialException;
import fr.kosmos.web.projets.extensions.social.service.ServiceFacebook;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class InterpreteurFacebookTag
extends DefaultInterpreteurTemplateTag {
    private static final Logger LOG = LoggerFactory.getLogger(InterpreteurFacebookTag.class);
    @Autowired
    private ServiceFacebook serviceFacebook;

    public String interpreterTag(String texteAInterpreter, String baliseOuvrante, String baliseFermante) throws Exception {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        String contenuTag = StringUtils.substringBetween((String)texteAInterpreter, (String)baliseOuvrante, (String)baliseFermante);
        if (contenuTag != null && StringUtils.isNotBlank((CharSequence)contenuTag)) {
            String iduser = "";
            int maxResults = 0;
            String[] contenuTagSplit = contenuTag.split(";");
            if (contenuTagSplit.length > 0) {
                iduser = contenuTagSplit[0];
            }
            if (contenuTagSplit.length > 1) {
                maxResults = Integer.valueOf(contenuTagSplit[1]);
            }
            try {
                List<FacebookFeedBean> listeTweets = this.serviceFacebook.getPosts(iduser, maxResults);
                ctx.putData("facebookListe", listeTweets);
            }
            catch (SocialException e) {
                LOG.error("Erreur rencontr\u00e9e lors de la r\u00e9cup\u00e9ration des posts Facebook", (Throwable)e);
                ctx.putData("facebookException", (Object)e);
            }
        }
        return this.getOutputJsp(ctx.getJspWriter(), ctx.getServletContext(), ctx.getRequeteHTTP(), ctx.getReponseHTTP());
    }

    public final ServiceFacebook getServiceFacebook() {
        return this.serviceFacebook;
    }

    public final void setServiceFacebook(ServiceFacebook serviceFacebook) {
        this.serviceFacebook = serviceFacebook;
    }
}

