/*
 * Decompiled with CFR 0.152.
 */
package fr.kosmos.web.projets.extensions.social.tag.interpreteur;

import com.kportal.tag.interpreteur.impl.DefaultInterpreteurTemplateTag;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import fr.kosmos.web.projets.extensions.social.bean.TweetBean;
import fr.kosmos.web.projets.extensions.social.exception.SocialException;
import fr.kosmos.web.projets.extensions.social.service.ServiceTwitter;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class InterpreteurTwitterTag
extends DefaultInterpreteurTemplateTag {
    private static final Logger LOG = LoggerFactory.getLogger(InterpreteurTwitterTag.class);
    @Autowired
    private ServiceTwitter serviceTwitter;

    public String interpreterTag(String texteAInterpreter, String baliseOuvrante, String baliseFermante) throws Exception {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        String contenuTag = StringUtils.substringBetween((String)texteAInterpreter, (String)baliseOuvrante, (String)baliseFermante);
        if (contenuTag != null && StringUtils.isNotBlank((CharSequence)contenuTag)) {
            String query = "";
            int maxResults = 0;
            String[] contenuTagSplit = contenuTag.split(";");
            if (contenuTagSplit.length > 0) {
                query = contenuTagSplit[0];
            }
            if (contenuTagSplit.length > 1) {
                maxResults = Integer.valueOf(contenuTagSplit[1]);
            }
            ctx.putData("twitterQuery", (Object)query);
            try {
                List<TweetBean> listeTweets = this.serviceTwitter.getTweets(query, maxResults);
                ctx.putData("twitterListe", listeTweets);
            }
            catch (SocialException e) {
                LOG.error("Erreur rencontr\u00e9e lors de la r\u00e9cup\u00e9ration des tweets", (Throwable)e);
                ctx.putData("twitterException", (Object)e);
            }
        }
        return this.getOutputJsp(ctx.getJspWriter(), ctx.getServletContext(), ctx.getRequeteHTTP(), ctx.getReponseHTTP());
    }

    public final ServiceTwitter getServiceTwitter() {
        return this.serviceTwitter;
    }

    public final void setServiceTwitter(ServiceTwitter serviceTwitter) {
        this.serviceTwitter = serviceTwitter;
    }
}

