/*
 * Decompiled with CFR 0.152.
 */
package fr.kosmos.web.projets.extensions.social.util;

import fr.kosmos.web.projets.extensions.social.bean.FacebookFeedBean;
import fr.kosmos.web.projets.extensions.social.bean.FacebookTagBean;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.text.StrBuilder;

public class FacebookUtil {
    private FacebookUtil() {
    }

    public static String toHtml(FacebookFeedBean post) {
        if (post.getMessage() == null) {
            return "";
        }
        StrBuilder message = new StrBuilder(post.getMessage());
        FacebookUtil.parseTags(post, message);
        message.replaceAll("\n", "<br/>");
        return message.toString();
    }

    private static void parseTags(FacebookFeedBean post, StrBuilder contenu) {
        List<FacebookTagBean> messageTags = post.getMessageTags();
        if (CollectionUtils.isNotEmpty(messageTags)) {
            for (FacebookTagBean facebookTagBean : messageTags) {
                String pattern = String.format("<a href=\"https://www.facebook.com/%1$s\" title=\"%2$s\">%2$s</a>", facebookTagBean.getId(), facebookTagBean.getName());
                contenu.replaceFirst(facebookTagBean.getName(), pattern);
            }
        }
    }
}

