/*
 * Decompiled with CFR 0.152.
 */
package fr.kosmos.web.projets.extensions.social.util;

import com.kportal.core.config.MessageHelper;
import com.kportal.extension.ExtensionHelper;
import com.kportal.extension.IExtension;
import com.kportal.extension.module.IModule;
import com.univ.utils.ContexteUtil;
import fr.kosmos.web.projets.extensions.social.bean.SocialBean;
import java.text.MessageFormat;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.ocpsoft.prettytime.PrettyTime;

public final class SocialUtil {
    public static final String ID_EXTENSION = "social";
    public static final String ID_MODULE_TWITTER = "socialModuleTwitter";
    public static final String ID_MODULE_FACEBOOK = "socialModuleFacebook";
    public static final String ID_MODULE_INSTAGRAM = "socialModuleInstagram";
    public static final String ID_MODULE_YOUTUBE = "socialModuleYoutube";
    public static final String ID_MODULE_LINKEDIN = "socialModuleLinkedin";
    public static final String ID_BEAN_TWITTER_CONSUMER_KEY = "twitterConsumerKey";
    public static final String ID_BEAN_TWITTER_CONSUMER_SECRET = "twitterConsumerSecret";
    public static final String ID_BEAN_FACEBOOK_CONSUMER_KEY = "facebookConsumerKey";
    public static final String ID_BEAN_FACEBOOK_CONSUMER_SECRET = "facebookConsumerSecret";
    public static final String ID_BEAN_INSTAGRAM_CLIENT_ID = "instagramClientId";
    public static final String ID_BEAN_INSTAGRAM_CLIENT_SECRET = "instagramClientSecret";
    public static final String ID_BEAN_INSTAGRAM_ACCESS_TOKEN = "instagramAccessToken";
    public static final String ID_BEAN_LINKEDIN_CLIENT_ID = "linkedinClientId";
    public static final String ID_BEAN_LINKEDIN_CLIENT_SECRET = "linkedinClientSecret";
    public static final String ID_BEAN_LINKEDIN_ACCESS_TOKEN = "linkedinAccessToken";
    public static final String ID_BEAN_YOUTUBE_API_KEY = "youtubeApiKey";
    public static final String PROPRIETE_TWITTER_CONSUMER_KEY = "TWITTER_CONSUMER_KEY";
    public static final String PROPRIETE_TWITTER_CONSUMER_SECRET = "TWITTER_CONSUMER_SECRET";
    public static final String PROPRIETE_FACEBOOK_CONSUMER_KEY = "FACEBOOK_CONSUMER_KEY";
    public static final String PROPRIETE_FACEBOOK_CONSUMER_SECRET = "FACEBOOK_CONSUMER_SECRET";
    public static final String PROPRIETE_INSTAGRAM_CLIENT_ID = "INSTAGRAM_CLIENT_ID";
    public static final String PROPRIETE_INSTAGRAM_CLIENT_SECRET = "INSTAGRAM_CLIENT_SECRET";
    public static final String PROPRIETE_INSTAGRAM_ACCESS_TOKEN = "INSTAGRAM_ACCESS_TOKEN";
    public static final String PROPRIETE_LINKEDIN_CLIENT_ID = "LINKEDIN_CLIENT_ID";
    public static final String PROPRIETE_LINKEDIN_CLIENT_SECRET = "LINKEDIN_CLIENT_SECRET";
    public static final String PROPRIETE_LINKEDIN_ACCESS_TOKEN = "LINKEDIN_ACCESS_TOKEN";
    public static final String PROPRIETE_YOUTUBE_API_KEY = "YOUTUBE_API_KEY";

    private SocialUtil() {
    }

    public static String getTwitterConsumerKey() {
        return StringUtils.defaultString((String)ContexteUtil.getContexteUniv().getInfosSite().getProprieteComplementaireString(PROPRIETE_TWITTER_CONSUMER_KEY));
    }

    public static String getTwitterConsumerSecret() {
        return StringUtils.defaultString((String)ContexteUtil.getContexteUniv().getInfosSite().getProprieteComplementaireString(PROPRIETE_TWITTER_CONSUMER_SECRET));
    }

    public static String getFacebookConsumerKey() {
        return StringUtils.defaultString((String)ContexteUtil.getContexteUniv().getInfosSite().getProprieteComplementaireString(PROPRIETE_FACEBOOK_CONSUMER_KEY));
    }

    public static String getFacebookConsumerSecret() {
        return StringUtils.defaultString((String)ContexteUtil.getContexteUniv().getInfosSite().getProprieteComplementaireString(PROPRIETE_FACEBOOK_CONSUMER_SECRET));
    }

    public static String getInstagramClientId() {
        return StringUtils.defaultString((String)ContexteUtil.getContexteUniv().getInfosSite().getProprieteComplementaireString(PROPRIETE_INSTAGRAM_CLIENT_ID));
    }

    public static String getInstagramAcessToken() {
        return StringUtils.defaultString((String)ContexteUtil.getContexteUniv().getInfosSite().getProprieteComplementaireString(PROPRIETE_INSTAGRAM_ACCESS_TOKEN));
    }

    public static String getInstagramClientSecret() {
        return StringUtils.defaultString((String)ContexteUtil.getContexteUniv().getInfosSite().getProprieteComplementaireString(PROPRIETE_INSTAGRAM_CLIENT_SECRET));
    }

    public static String getLinkedinClientId() {
        return StringUtils.defaultString((String)ContexteUtil.getContexteUniv().getInfosSite().getProprieteComplementaireString(PROPRIETE_LINKEDIN_CLIENT_ID));
    }

    public static String getLinkedinClientSecret() {
        return StringUtils.defaultString((String)ContexteUtil.getContexteUniv().getInfosSite().getProprieteComplementaireString(PROPRIETE_LINKEDIN_CLIENT_SECRET));
    }

    public static String getLinkedinAccessToken() {
        return StringUtils.defaultString((String)ContexteUtil.getContexteUniv().getInfosSite().getProprieteComplementaireString(PROPRIETE_LINKEDIN_ACCESS_TOKEN));
    }

    public static String getYoutubeApiKey() {
        return StringUtils.defaultString((String)ContexteUtil.getContexteUniv().getInfosSite().getProprieteComplementaireString(PROPRIETE_YOUTUBE_API_KEY));
    }

    private static IExtension getExtension() {
        return ExtensionHelper.getExtension((String)ID_EXTENSION);
    }

    public static boolean isExtensionEnabled() {
        IExtension extension = SocialUtil.getExtension();
        return extension != null && extension.getEtat() == 1;
    }

    public static boolean isModuleEnabled(final String module) {
        boolean activated;
        IExtension extension = SocialUtil.getExtension();
        boolean bl = activated = extension != null && extension.getEtat() == 1;
        if (activated) {
            Collection modules = extension.getModules();
            activated = CollectionUtils.exists((Collection)modules, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    IModule moduleItem = (IModule)object;
                    return moduleItem.getId().equals(module) && moduleItem.getEtat() == 1;
                }
            });
        }
        return activated;
    }

    public static boolean isTwitterEnabled() {
        return SocialUtil.isModuleEnabled(ID_MODULE_TWITTER);
    }

    public static boolean isFacebookEnabled() {
        return SocialUtil.isModuleEnabled(ID_MODULE_FACEBOOK);
    }

    public static boolean isInstagramEnabled() {
        return SocialUtil.isModuleEnabled(ID_MODULE_INSTAGRAM);
    }

    public static boolean isLinkedinEnabled() {
        return SocialUtil.isModuleEnabled(ID_MODULE_LINKEDIN);
    }

    public static boolean isYoutubeEnabled() {
        return SocialUtil.isModuleEnabled(ID_MODULE_YOUTUBE);
    }

    public static String getMessage(String key) {
        return MessageHelper.getMessage((String)ID_EXTENSION, (String)key);
    }

    public static String getMessage(String key, Object ... arguments) {
        return SocialUtil.getMessage(ID_EXTENSION, key, arguments);
    }

    public static String getMessage(String extension, String key, Object ... arguments) {
        String pattern = MessageHelper.getMessage((String)extension, (String)key);
        if (StringUtils.isNotEmpty((CharSequence)pattern)) {
            return MessageFormat.format(pattern, arguments);
        }
        return "";
    }

    public static String getDatePost(SocialBean postReseauSocial) {
        if (null == postReseauSocial || null == postReseauSocial.getDateCreated()) {
            return "";
        }
        PrettyTime prettyTime = new PrettyTime(ContexteUtil.getContexteUniv().getLocale());
        return prettyTime.format(postReseauSocial.getDateCreated());
    }
}

