/*
 * Decompiled with CFR 0.152.
 */
package fr.kosmos.web.projets.extensions.social.util;

import com.kportal.core.config.PropertyHelper;
import fr.kosmos.web.projets.extensions.social.bean.TweetBean;
import fr.kosmos.web.projets.extensions.social.bean.TwitterHashtagBean;
import fr.kosmos.web.projets.extensions.social.bean.TwitterMediaBean;
import fr.kosmos.web.projets.extensions.social.bean.TwitterUrlBean;
import fr.kosmos.web.projets.extensions.social.bean.TwitterUserMentionBean;
import fr.kosmos.web.projets.extensions.social.util.SocialUtil;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;

public final class TwitterUtil {
    public static final String HASHTAGS_PATTERN = "social.tag.hashtag.pattern";

    private TwitterUtil() {
    }

    public static String toHtml(TweetBean tweet) {
        if (null == tweet) {
            return "";
        }
        StringBuilder contenu = new StringBuilder(tweet.getText());
        TwitterUtil.parseRetweet(tweet, contenu);
        TwitterUtil.parseUserMention(tweet, contenu);
        TwitterUtil.parseHashtag(tweet, contenu);
        TwitterUtil.parseMedia(tweet, contenu);
        TwitterUtil.parseURL(tweet, contenu);
        return contenu.toString();
    }

    public static void parseRetweet(TweetBean tweet, StringBuilder contenu) {
        if (tweet.isRetweet()) {
            contenu.delete(0, 2);
        }
    }

    public static void parseMedia(TweetBean tweet, StringBuilder contenu) {
        for (TwitterMediaBean media : tweet.getMediaTwitterList()) {
            String pattern = String.format("<a href=\"%1$s\" title=\"%1$s\">%1$s</a>", media.getUrl());
            contenu.replace(0, contenu.length(), StringUtils.replace((String)contenu.toString(), (String)media.getUrl(), (String)pattern));
        }
    }

    public static void parseHashtag(TweetBean tweet, StringBuilder contenu) {
        for (TwitterHashtagBean media : tweet.getHashtagList()) {
            String pattern = String.format("<a href=\"%1$s\" title=\"#%2$s\">#%2$s</a>", MessageFormat.format(PropertyHelper.getProperty((String)"social", (String)HASHTAGS_PATTERN), media.getText()), media.getText());
            contenu.replace(0, contenu.length(), StringUtils.replace((String)contenu.toString(), (String)("#" + media.getText()), (String)pattern));
        }
    }

    public static void parseUserMention(TweetBean tweet, StringBuilder contenu) {
        for (TwitterUserMentionBean media : tweet.getUserMentionList()) {
            String pattern = String.format("<a href=\"https://twitter.com/%1$s\" title=\"@%1$s\">@%1$s</a>", media.getScreenName());
            contenu.replace(0, contenu.length(), StringUtils.replace((String)contenu.toString(), (String)("@" + media.getScreenName()), (String)pattern));
        }
    }

    public static void parseURL(TweetBean tweet, StringBuilder contenu) {
        for (TwitterUrlBean media : tweet.getUrlTwitterList()) {
            String pattern = String.format("<a href=\"%1$s\" title=\"%1$s\">%1$s</a>", media.getUrl());
            contenu.replace(0, contenu.length(), StringUtils.replace((String)contenu.toString(), (String)media.getUrl(), (String)pattern));
        }
    }

    @Deprecated
    public static String getDateSoumissionTweet(TweetBean tweet) {
        return SocialUtil.getDatePost(tweet);
    }
}

