/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.service.captchastore;

import com.octo.captcha.Captcha;
import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.captchastore.CaptchaAndLocale;
import com.octo.captcha.service.captchastore.CaptchaStore;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class MapCaptchaStore
implements CaptchaStore {
    Map store = new HashMap();

    @Override
    public boolean hasCaptcha(String id) {
        return this.store.containsKey(id);
    }

    @Override
    public void storeCaptcha(String id, Captcha captcha) throws CaptchaServiceException {
        this.store.put(id, new CaptchaAndLocale(captcha));
    }

    @Override
    public void storeCaptcha(String id, Captcha captcha, Locale locale) throws CaptchaServiceException {
        this.store.put(id, new CaptchaAndLocale(captcha, locale));
    }

    @Override
    public Captcha getCaptcha(String id) throws CaptchaServiceException {
        Object captchaAndLocale = this.store.get(id);
        return captchaAndLocale != null ? ((CaptchaAndLocale)captchaAndLocale).getCaptcha() : null;
    }

    @Override
    public Locale getLocale(String id) throws CaptchaServiceException {
        Object captchaAndLocale = this.store.get(id);
        return captchaAndLocale != null ? ((CaptchaAndLocale)captchaAndLocale).getLocale() : null;
    }

    @Override
    public boolean removeCaptcha(String id) {
        if (this.store.get(id) != null) {
            this.store.remove(id);
            return true;
        }
        return false;
    }

    @Override
    public int getSize() {
        return this.store.size();
    }

    @Override
    public Collection getKeys() {
        return this.store.keySet();
    }

    @Override
    public void empty() {
        this.store = new HashMap();
    }

    @Override
    public void initAndStart() {
    }

    @Override
    public void cleanAndShutdown() {
        this.store.clear();
    }
}

