/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.harvester;

import ORG.oclc.oai.harvester.OAIHarvesterFunction;
import ORG.oclc.oai.harvester.OAIServer;
import ORG.oclc.oai.harvester.OAIServerSet;
import ORG.oclc.oai.harvester.crosswalk.Crosswalk;
import ORG.oclc.oai.harvester.verb.GetRecord;
import ORG.oclc.oai.harvester.verb.HarvesterVerb;
import ORG.oclc.oai.harvester.verb.Identify;
import ORG.oclc.oai.harvester.verb.ListMetadataFormats;
import ORG.oclc.oai.harvester.verb.ListRecords;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.xml.sax.SAXException;

public class Harvester {
    private static final boolean debug = false;
    private static final String USAGE = "java Harvester [-p propertiesfile] [-u URL [-r resumptionToken -m metadataPrefix] [-i identifierListFileName -m metadataPrefix]] [-f lastHarvestDateOverride] [-t untilDateOverride]\n(The default propertiesfile is 'harvester.properties')";
    private URL baseURL;
    private String setSpec;
    private String lastHarvestDate;
    private String untilDate;
    private OAIHarvesterFunction oaiHarvesterFunction;
    private int numRecsProcessed = 0;
    private Identify identify;
    private ListMetadataFormats listMetadataFormats;

    public Harvester(OAIHarvesterFunction oaiHarvesterFunction, OAIServer oaiServer, String lastHarvestDateOverride, String untilDateOverride) throws MalformedURLException {
        this.oaiHarvesterFunction = oaiHarvesterFunction;
        this.setSpec = oaiServer.getSetSpec();
        this.baseURL = new URL(oaiServer.getBaseURL());
        if (!this.baseURL.getProtocol().toLowerCase().startsWith("http")) {
            throw new IllegalArgumentException("Harvester only works for http URLs");
        }
        try {
            this.identify = new Identify(this.baseURL);
            this.listMetadataFormats = new ListMetadataFormats(this.baseURL);
            oaiHarvesterFunction.setIdentify(this.identify);
            oaiHarvesterFunction.setListMetadataFormats(this.listMetadataFormats);
        }
        catch (FileNotFoundException e) {
            System.err.print("Server not found: ");
            System.err.println(this.baseURL);
            return;
        }
        catch (ConnectException e) {
            System.err.print(e.getMessage());
            System.err.print(": ");
            System.err.println(this.baseURL);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (lastHarvestDateOverride != null) {
            this.lastHarvestDate = lastHarvestDateOverride;
        } else {
            this.lastHarvestDate = oaiServer.getLastHarvestDate();
            if (this.lastHarvestDate == null) {
                this.lastHarvestDate = this.identify.getEarliestDatestamp();
            }
        }
        this.lastHarvestDate = this.fixGranularity(this.lastHarvestDate, this.identify.getGranularity());
        this.untilDate = untilDateOverride;
        String responseDate = this.identify.getResponseDate();
        if (this.untilDate == null) {
            this.untilDate = this.fixGranularity(responseDate, this.identify.getGranularity());
        }
    }

    public String getBaseURL() {
        return this.baseURL.toString();
    }

    public String getSetSpec() {
        return this.setSpec;
    }

    public String getUntilDate() {
        return this.untilDate;
    }

    public int getNumRecsProcessed() {
        return this.numRecsProcessed;
    }

    private String fixGranularity(String utcDate, String supportedGranularity) {
        StringBuffer sb = new StringBuffer(utcDate);
        int supportedLen = supportedGranularity.length();
        if (utcDate.length() > supportedLen) {
            switch (supportedLen) {
                case 10: {
                    sb.setLength(supportedLen);
                    break;
                }
                case 17: {
                    sb.setLength(supportedLen - 1);
                    sb.append("Z");
                    break;
                }
                case 22: {
                    sb.setLength(supportedLen - 1);
                    sb.append(".0Z");
                    break;
                }
            }
        }
        return sb.toString();
    }

    public boolean run(String resumptionTokenOverride, String metadataPrefix) {
        boolean success = true;
        if (resumptionTokenOverride == null) {
            return this.run();
        }
        try {
            ListRecords listRecords;
            Crosswalk crosswalk = this.oaiHarvesterFunction.getCrosswalks().getCrosswalk(metadataPrefix);
            try {
                listRecords = new ListRecords(this.baseURL, resumptionTokenOverride);
            }
            catch (SAXException e) {
                listRecords = null;
                success = false;
            }
            int retriesLeft = 10;
            block8: while (listRecords != null) {
                ArrayList errors = listRecords.getErrors();
                if (errors != null) {
                    Iterator iterator = errors.iterator();
                    while (iterator.hasNext()) {
                        System.out.println(iterator.next());
                    }
                }
                Iterator records = listRecords.iterator();
                this.numRecsProcessed += this.oaiHarvesterFunction.process(records, metadataPrefix, crosswalk);
                String resumptionToken = listRecords.getResumptionToken();
                if (resumptionToken != null) {
                    System.out.println(resumptionToken);
                    listRecords = null;
                    while (listRecords == null) {
                        try {
                            listRecords = new ListRecords(this.baseURL, resumptionToken);
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                            System.err.print("Abandoning:\nbaseURL:");
                            System.err.println(this.baseURL.toString());
                            System.err.print("lastHarvestDate:");
                            System.err.println(this.lastHarvestDate);
                            System.err.print("untilDate:");
                            System.err.println(this.untilDate);
                            System.err.print("setSpec:");
                            System.err.println(this.setSpec);
                            System.err.print("metadataPrefix:");
                            System.err.println(metadataPrefix);
                            System.err.print("resumptionToken:");
                            System.err.println(resumptionToken);
                            success = false;
                            continue block8;
                        }
                        catch (ConnectException e) {
                            e.printStackTrace();
                            System.err.print("retries left: ");
                            System.err.println(retriesLeft);
                            if (retriesLeft == 0) {
                                System.err.print("Abandoning:\nbaseURL:");
                                System.err.println(this.baseURL.toString());
                                System.err.print("lastHarvestDate:");
                                System.err.println(this.lastHarvestDate);
                                System.err.print("untilDate:");
                                System.err.println(this.untilDate);
                                System.err.print("setSpec:");
                                System.err.println(this.setSpec);
                                System.err.print("metadataPrefix:");
                                System.err.println(metadataPrefix);
                                System.err.print("resumptionToken:");
                                System.err.println(resumptionToken);
                                success = false;
                                continue block8;
                            }
                            System.err.println("sleep for 10 seconds...");
                            Thread.currentThread();
                            Thread.sleep(10000L);
                            --retriesLeft;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.err.print("Abandoning:\nbaseURL:");
                            System.err.println(this.baseURL.toString());
                            System.err.print("lastHarvestDate:");
                            System.err.println(this.lastHarvestDate);
                            System.err.print("untilDate:");
                            System.err.println(this.untilDate);
                            System.err.print("setSpec:");
                            System.err.println(this.setSpec);
                            System.err.print("metadataPrefix:");
                            System.err.println(metadataPrefix);
                            System.err.print("resumptionToken:");
                            System.err.println(resumptionToken);
                            success = false;
                            continue block8;
                        }
                    }
                    continue;
                }
                listRecords = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            success = false;
        }
        return success;
    }

    public boolean run() {
        boolean success = true;
        try {
            Iterator crosswalks = this.oaiHarvesterFunction.getCrosswalks().iterator();
            while (crosswalks.hasNext()) {
                HarvesterVerb listRecords;
                Map.Entry entry = (Map.Entry)crosswalks.next();
                String metadataPrefix = (String)entry.getKey();
                Crosswalk crosswalk = (Crosswalk)entry.getValue();
                try {
                    listRecords = new ListRecords(this.baseURL, this.lastHarvestDate, this.untilDate, this.setSpec, metadataPrefix);
                }
                catch (SAXException e) {
                    listRecords = null;
                }
                int retriesLeft = 10;
                block9: while (listRecords != null) {
                    ArrayList errors = listRecords.getErrors();
                    if (errors != null) {
                        Iterator iterator = errors.iterator();
                        while (iterator.hasNext()) {
                            System.out.println(iterator.next());
                        }
                    }
                    Iterator records = ((ListRecords)listRecords).iterator();
                    this.numRecsProcessed += this.oaiHarvesterFunction.process(records, metadataPrefix, crosswalk);
                    String resumptionToken = ((ListRecords)listRecords).getResumptionToken();
                    if (resumptionToken != null) {
                        System.out.println(resumptionToken);
                        listRecords = null;
                        while (listRecords == null) {
                            try {
                                listRecords = new ListRecords(this.baseURL, resumptionToken);
                            }
                            catch (FileNotFoundException e) {
                                e.printStackTrace();
                                System.err.print("Abandoning:\nbaseURL:");
                                System.err.println(this.baseURL.toString());
                                System.err.print("lastHarvestDate:");
                                System.err.println(this.lastHarvestDate);
                                System.err.print("untilDate:");
                                System.err.println(this.untilDate);
                                System.err.print("setSpec:");
                                System.err.println(this.setSpec);
                                System.err.print("metadataPrefix:");
                                System.err.println(metadataPrefix);
                                System.err.print("resumptionToken:");
                                System.err.println(resumptionToken);
                                success = false;
                                continue block9;
                            }
                            catch (ConnectException e) {
                                e.printStackTrace();
                                System.err.print("retries left: ");
                                System.err.println(retriesLeft);
                                if (retriesLeft == 0) {
                                    System.err.print("Abandoning:\nbaseURL:");
                                    System.err.println(this.baseURL.toString());
                                    System.err.print("lastHarvestDate:");
                                    System.err.println(this.lastHarvestDate);
                                    System.err.print("untilDate:");
                                    System.err.println(this.untilDate);
                                    System.err.print("setSpec:");
                                    System.err.println(this.setSpec);
                                    System.err.print("metadataPrefix:");
                                    System.err.println(metadataPrefix);
                                    System.err.print("resumptionToken:");
                                    System.err.println(resumptionToken);
                                    success = false;
                                    continue block9;
                                }
                                System.err.println("sleep for 10 seconds...");
                                Thread.currentThread();
                                Thread.sleep(10000L);
                                --retriesLeft;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                System.err.print("Abandoning:\nbaseURL:");
                                System.err.println(this.baseURL.toString());
                                System.err.print("lastHarvestDate:");
                                System.err.println(this.lastHarvestDate);
                                System.err.print("untilDate:");
                                System.err.println(this.untilDate);
                                System.err.print("setSpec:");
                                System.err.println(this.setSpec);
                                System.err.print("metadataPrefix:");
                                System.err.println(metadataPrefix);
                                System.err.print("resumptionToken:");
                                System.err.println(resumptionToken);
                                success = false;
                                continue block9;
                            }
                        }
                        continue;
                    }
                    listRecords = null;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            success = false;
        }
        return success;
    }

    public boolean run(Iterator identifierOverride, String metadataPrefix) {
        boolean success = true;
        try {
            GetRecord getRecord;
            Crosswalk crosswalk = this.oaiHarvesterFunction.getCrosswalks().getCrosswalk(metadataPrefix);
            try {
                getRecord = new GetRecord(this.baseURL, (String)identifierOverride.next(), metadataPrefix);
            }
            catch (SAXException e) {
                getRecord = null;
            }
            int retriesLeft = 10;
            block8: while (getRecord != null) {
                ArrayList errors = getRecord.getErrors();
                if (errors != null) {
                    Iterator iterator = errors.iterator();
                    while (iterator.hasNext()) {
                        System.out.println(iterator.next());
                    }
                }
                Iterator records = getRecord.iterator();
                this.numRecsProcessed += this.oaiHarvesterFunction.process(records, metadataPrefix, crosswalk);
                if (identifierOverride.hasNext()) {
                    getRecord = null;
                    while (getRecord == null) {
                        try {
                            getRecord = new GetRecord(this.baseURL, (String)identifierOverride.next(), metadataPrefix);
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                            System.err.print("Abandoning:\nbaseURL:");
                            System.err.println(this.baseURL.toString());
                            System.err.print("lastHarvestDate:");
                            System.err.println(this.lastHarvestDate);
                            System.err.print("untilDate:");
                            System.err.println(this.untilDate);
                            System.err.print("setSpec:");
                            System.err.println(this.setSpec);
                            System.err.print("metadataPrefix:");
                            System.err.println(metadataPrefix);
                            success = false;
                            continue block8;
                        }
                        catch (ConnectException e) {
                            e.printStackTrace();
                            System.err.print("retries left: ");
                            System.err.println(retriesLeft);
                            if (retriesLeft == 0) {
                                System.err.print("Abandoning:\nbaseURL:");
                                System.err.println(this.baseURL.toString());
                                System.err.print("lastHarvestDate:");
                                System.err.println(this.lastHarvestDate);
                                System.err.print("untilDate:");
                                System.err.println(this.untilDate);
                                System.err.print("setSpec:");
                                System.err.println(this.setSpec);
                                System.err.print("metadataPrefix:");
                                System.err.println(metadataPrefix);
                                success = false;
                                continue block8;
                            }
                            System.err.println("sleep for 10 seconds...");
                            Thread.currentThread();
                            Thread.sleep(10000L);
                            --retriesLeft;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.err.print("Abandoning:\nbaseURL:");
                            System.err.println(this.baseURL.toString());
                            System.err.print("lastHarvestDate:");
                            System.err.println(this.lastHarvestDate);
                            System.err.print("untilDate:");
                            System.err.println(this.untilDate);
                            System.err.print("setSpec:");
                            System.err.println(this.setSpec);
                            System.err.print("metadataPrefix:");
                            System.err.println(metadataPrefix);
                            success = false;
                            continue block8;
                        }
                    }
                    continue;
                }
                getRecord = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            success = false;
        }
        return success;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.baseURL);
        sb.append(" will be harvested from ");
        sb.append(this.lastHarvestDate);
        sb.append(" up to ");
        sb.append(this.untilDate);
        sb.append("\n\n");
        sb.append(this.identify.toString());
        sb.append("\n\n");
        sb.append(this.listMetadataFormats.toString());
        sb.append("\n");
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static final void main(String[] args) {
        baseURL = null;
        setSpec = null;
        propertiesFileName = "harvester.properties";
        lastHarvestDateOverride = null;
        untilDateOverride = null;
        resumptionTokenOverride = null;
        metadataPrefixOverride = null;
        identifierOverride = null;
        i = 0;
        while (i < args.length) {
            block37: {
                try {
                    if (args[i].equals("-p")) {
                        propertiesFileName = args[++i];
                        break block37;
                    }
                    if (args[i].equals("-u")) {
                        baseURL = args[++i];
                        break block37;
                    }
                    if (args[i].equals("-m")) {
                        metadataPrefixOverride = args[++i];
                        break block37;
                    }
                    if (args[i].equals("-s")) {
                        setSpec = args[++i];
                        break block37;
                    }
                    if (args[i].equals("-f")) {
                        lastHarvestDateOverride = args[++i];
                        break block37;
                    }
                    if (args[i].equals("-t")) {
                        untilDateOverride = args[++i];
                        break block37;
                    }
                    if (args[i].equals("-r")) {
                        resumptionTokenOverride = args[++i];
                        break block37;
                    }
                    if (args[i].equals("-i")) {
                        identifierOverride = new ArrayList<String>();
                        try {
                            fr = new FileReader(args[++i]);
                            br = new BufferedReader(fr);
                            while ((line = br.readLine()) != null) {
                                line = var12_15.trim();
                                if (line.length() <= 0) continue;
                                identifierOverride.add(line);
                            }
                            br.close();
                            fr.close();
                            break block37;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return;
                        }
                    }
                    System.out.println("java Harvester [-p propertiesfile] [-u URL [-r resumptionToken -m metadataPrefix] [-i identifierListFileName -m metadataPrefix]] [-f lastHarvestDateOverride] [-t untilDateOverride]\n(The default propertiesfile is 'harvester.properties')");
                    return;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.out.println("java Harvester [-p propertiesfile] [-u URL [-r resumptionToken -m metadataPrefix] [-i identifierListFileName -m metadataPrefix]] [-f lastHarvestDateOverride] [-t untilDateOverride]\n(The default propertiesfile is 'harvester.properties')");
                    return;
                }
            }
            ++i;
        }
        if (resumptionTokenOverride != null && baseURL == null) {
            System.out.println("The -r parameter can only be used in association with the -u parameter");
            System.out.println("java Harvester [-p propertiesfile] [-u URL [-r resumptionToken -m metadataPrefix] [-i identifierListFileName -m metadataPrefix]] [-f lastHarvestDateOverride] [-t untilDateOverride]\n(The default propertiesfile is 'harvester.properties')");
            return;
        }
        if (identifierOverride != null && baseURL == null) {
            System.out.println("The -i parameter can only be used in association with the -u parameter");
            System.out.println("java Harvester [-p propertiesfile] [-u URL [-r resumptionToken -m metadataPrefix] [-i identifierListFileName -m metadataPrefix]] [-f lastHarvestDateOverride] [-t untilDateOverride]\n(The default propertiesfile is 'harvester.properties')");
            return;
        }
        if (resumptionTokenOverride != null && metadataPrefixOverride == null) {
            System.out.println("The -m parameter must be used in conjunction with the -r parameter");
            System.out.println("java Harvester [-p propertiesfile] [-u URL [-r resumptionToken -m metadataPrefix] [-i identifierListFileName -m metadataPrefix]] [-f lastHarvestDateOverride] [-t untilDateOverride]\n(The default propertiesfile is 'harvester.properties')");
            return;
        }
        if (identifierOverride != null && metadataPrefixOverride == null) {
            System.out.println("The -m parameter must be used in conjunction with the -i parameter");
            System.out.println("java Harvester [-p propertiesfile] [-u URL [-r resumptionToken -m metadataPrefix] [-i identifierListFileName -m metadataPrefix]] [-f lastHarvestDateOverride] [-t untilDateOverride]\n(The default propertiesfile is 'harvester.properties')");
            return;
        }
        properties = new Properties();
        try {
            properties.load(new FileInputStream(propertiesFileName));
        }
        catch (Exception e) {
            System.err.println("Failed to load properties: " + e.getMessage());
            return;
        }
        try {
            oaiHarvesterFunction = OAIHarvesterFunction.factory(properties);
            oaiServerSet = OAIServerSet.factory(properties, baseURL, setSpec);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
            return;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
            return;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
            return;
        }
        catch (Throwable e) {
            e.printStackTrace();
            e.printStackTrace();
            return;
        }
        oaiServerSetIterator = oaiServerSet.iterator();
        if (oaiServerSetIterator != null) ** GOTO lbl133
        System.err.println("Failed to retrieve OAIServerSet iterator");
        return;
lbl-1000:
        // 1 sources

        {
            oaiServer = (OAIServer)oaiServerSetIterator.next();
            try {
                System.out.println("Start: " + new Date());
                harvester = new Harvester(oaiHarvesterFunction, oaiServer, lastHarvestDateOverride, untilDateOverride);
                System.out.println(harvester);
                if (identifierOverride != null) {
                    if (harvester.run(identifierOverride.iterator(), metadataPrefixOverride)) {
                        oaiServer.setLastHarvestDate(harvester.getUntilDate());
                    } else {
                        System.out.println("Harvest failed.");
                    }
                } else if (harvester.run(resumptionTokenOverride, metadataPrefixOverride)) {
                    oaiServer.setLastHarvestDate(harvester.getUntilDate());
                } else {
                    System.out.println("Harvest failed.");
                }
                System.out.print(harvester.getNumRecsProcessed());
                System.out.print(" records processed from ");
                System.out.print(harvester.getBaseURL());
                System.out.print(" (setSpec='");
                System.out.print(harvester.getSetSpec());
                System.out.println("')");
                System.out.println("  End: " + new Date());
                continue;
            }
            catch (MalformedURLException e) {
                System.out.println(e);
                System.out.print("Harvest failed for baseURL: '");
                System.out.print(oaiServer.getBaseURL());
                System.out.println("'");
            }
lbl133:
            // 3 sources

            ** while (oaiServerSetIterator.hasNext())
        }
lbl134:
        // 1 sources

        try {
            if (baseURL == null) {
                oaiServerSet.store();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        oaiHarvesterFunction.close();
    }
}

