/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.harvester.io;

import ORG.oclc.oai.harvester.verb.ListRecords;
import ORG.oclc.oai.harvester.verb.OAIError;
import ORG.oclc.oai.harvester.verb.Record;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.xml.sax.SAXException;

public class OAIReader {
    private URL baseURL;
    private String resumptionToken = null;
    private Iterator records = null;

    public OAIReader(URL baseURL, String from, String until, String set, String metadataPrefix) throws MalformedURLException, SAXException, IOException, OAIError {
        this.baseURL = baseURL;
        ListRecords listRecords = new ListRecords(baseURL, from, until, set, metadataPrefix);
        if (listRecords != null) {
            ArrayList errors = listRecords.getErrors();
            if (errors != null) {
                throw (OAIError)errors.get(0);
            }
            this.records = listRecords.iterator();
            this.resumptionToken = listRecords.getResumptionToken();
        }
    }

    public Record readNext() throws MalformedURLException, SAXException, IOException, OAIError {
        while (this.records != null && !this.records.hasNext()) {
            if (this.resumptionToken == null) {
                return null;
            }
            ListRecords listRecords = new ListRecords(this.baseURL, this.resumptionToken);
            if (listRecords != null) {
                ArrayList errors = listRecords.getErrors();
                if (errors != null) {
                    throw (OAIError)errors.get(0);
                }
                this.records = listRecords.iterator();
                this.resumptionToken = listRecords.getResumptionToken();
                continue;
            }
            return null;
        }
        if (this.records == null) {
            return null;
        }
        return (Record)this.records.next();
    }

    public void close() {
    }
}

