/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.harvester.verb;

import ORG.oclc.oai.harvester.verb.HarvesterVerb;
import ORG.oclc.oai.util.OAIUtil;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class Header
extends DefaultHandler {
    private static final boolean debug = false;
    private String header = null;
    private static HashMap xmlReaders = new HashMap();
    private boolean identifierCapture = false;
    private StringBuffer identifier = new StringBuffer();
    private boolean datestampCapture = false;
    private StringBuffer datestamp = new StringBuffer();
    private boolean setSpecCapture = false;
    private ArrayList setSpecs = new ArrayList();
    private StringBuffer setSpec;
    private String status = null;

    public Header(String header) throws SAXException, IOException {
        this.header = header;
        XMLReader xmlReader = this.getXMLReader();
        xmlReader.setContentHandler(this);
        try {
            xmlReader.parse(new InputSource(new StringReader(header)));
        }
        catch (SAXException e) {
            System.out.println("Header.Header: header=" + header);
            e.printStackTrace();
            throw e;
        }
    }

    private XMLReader getXMLReader() throws SAXException {
        Thread currentThread = Thread.currentThread();
        XMLReader xmlReader = (XMLReader)xmlReaders.get(currentThread);
        if (xmlReader == null) {
            try {
                xmlReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            }
            catch (SAXException e) {
                try {
                    xmlReader = XMLReaderFactory.createXMLReader("org.apache.crimson.parser.XMLReaderImpl");
                }
                catch (SAXException e1) {
                    try {
                        xmlReader = XMLReaderFactory.createXMLReader("com.bluecase.xml.Piccolo");
                    }
                    catch (SAXException e2) {
                        try {
                            xmlReader = XMLReaderFactory.createXMLReader("oracle.xml.parser.v2.SAXParser");
                        }
                        catch (SAXException e3) {
                            try {
                                xmlReader = XMLReaderFactory.createXMLReader();
                            }
                            catch (SAXException e4) {
                                throw new SAXException("No SAX parser available");
                            }
                        }
                    }
                }
            }
            xmlReaders.put(currentThread, xmlReader);
        }
        return xmlReader;
    }

    public String getHeaderXML() {
        return this.header;
    }

    public boolean isDeleted() {
        return "deleted".equals(this.status);
    }

    public String getIdentifier() {
        return this.identifier.toString();
    }

    public String getDatestamp() {
        return this.datestamp.toString();
    }

    public Iterator getSetSpecs() {
        if (this.setSpecs.size() > 0) {
            return this.setSpecs.iterator();
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Header.identifier=");
        sb.append(this.getIdentifier());
        sb.append("\nHeader.datestamp=");
        sb.append(this.getDatestamp());
        Iterator setSpecs = this.getSetSpecs();
        if (setSpecs != null) {
            while (setSpecs.hasNext()) {
                sb.append("\nHeader.setSpec=");
                sb.append((String)setSpecs.next());
            }
        }
        sb.append("\nHeader.status=");
        sb.append(this.status);
        sb.append("\n");
        return sb.toString();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) {
        String fullName = HarvesterVerb.fullName(namespaceURI, localName);
        if (fullName.equals("#identifier")) {
            this.identifierCapture = true;
        } else if (fullName.equals("#datestamp")) {
            this.datestampCapture = true;
        } else if (fullName.equals("#setSpec")) {
            this.setSpecCapture = true;
            this.setSpec = new StringBuffer();
        } else if (!fullName.equals("#header")) {
            if (fullName.equals("#header")) {
                int length = attrs.getLength();
                int i = 0;
                while (i < length) {
                    String aEName = HarvesterVerb.fullName(attrs.getURI(i), attrs.getLocalName(i));
                    if (HarvesterVerb.OAI20_STATUS.equals(aEName)) {
                        this.status = attrs.getValue(i);
                    }
                    ++i;
                }
            } else {
                System.out.println("Unrecognized element: " + qName);
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        String fullName = HarvesterVerb.fullName(namespaceURI, localName);
        if (this.identifierCapture || this.datestampCapture || this.setSpecCapture) {
            // empty if block
        }
        if (fullName.equals("#identifier")) {
            this.identifierCapture = false;
        } else if (fullName.equals("#datestamp")) {
            this.datestampCapture = false;
        } else if (fullName.equals("#setSpec")) {
            this.setSpecs.add(this.setSpec.toString());
            this.setSpecCapture = false;
        }
    }

    public void characters(char[] buf, int offset, int len) {
        String s = new String(buf, offset, len);
        if (this.identifierCapture) {
            this.identifier.append(OAIUtil.xmlEncode(s));
        } else if (this.datestampCapture) {
            this.datestamp.append(OAIUtil.xmlEncode(s));
        } else if (this.setSpecCapture) {
            this.setSpec.append(OAIUtil.xmlEncode(s));
        } else if (s.trim().length() > 0) {
            System.out.println("Unrecognized content:" + s);
        }
    }
}

